/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.cropdusting.events;

import com.mramericanmike.cropdusting.configuration.ConfigValues;
import com.mramericanmike.cropdusting.utils.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityTickEvent {
    private int RADIUS = ConfigValues.effectPigRadius;
    private int CHANCES = ConfigValues.pigChances;

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase theEntity = event.getEntityLiving();
        World theWorld = theEntity.func_130014_f_();
        if (!theWorld.field_72995_K && theEntity != null && theEntity instanceof EntityPig && theEntity.func_145818_k_() && Utilities.isValidPigName(theEntity.func_95999_t()) && Utilities.randInt(1, this.CHANCES) == 1) {
            BlockPos thePosition = new BlockPos(theEntity.field_70165_t, theEntity.field_70163_u, theEntity.field_70161_v);
            for (int xAxis = -this.RADIUS; xAxis <= this.RADIUS; ++xAxis) {
                for (int zAxis = -this.RADIUS; zAxis <= this.RADIUS; ++zAxis) {
                    for (int yAxis = -1; yAxis <= 1; ++yAxis) {
                        BlockPos actualPos = new BlockPos((Vec3i)thePosition.func_177982_a(xAxis, yAxis, zAxis));
                        Block checkBlock = theWorld.func_180495_p(actualPos).func_177230_c();
                        if (!Utilities.isGrowable(checkBlock)) continue;
                        Utilities.doUpdates(theWorld, actualPos);
                    }
                }
            }
        }
    }
}

