/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.interpolate.position;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.Rotations3D;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import java.util.List;
import javax.vecmath.Matrix4f;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0012\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/teamwizardry/librarianlib/features/math/interpolate/position/InterpHelix;", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "Lnet/minecraft/util/math/Vec3d;", "point1", "point2", "radius1", "", "radius2", "rotations", "offset", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;FFFF)V", "disp", "len", "", "getOffset", "()F", "getPoint1", "()Lnet/minecraft/util/math/Vec3d;", "getPoint2", "radiansPerUnit", "getRadius1", "getRadius2", "getRotations", "transform", "Ljavax/vecmath/Matrix4f;", "Lcom/teamwizardry/librarianlib/features/math/AffineTransformation;", "get", "i", "librarianlib-1.12.2"})
public final class InterpHelix
implements InterpFunction<Vec3d> {
    private final Vec3d disp;
    private final double len;
    private final float radiansPerUnit;
    private final Matrix4f transform;
    @NotNull
    private final Vec3d point1;
    @NotNull
    private final Vec3d point2;
    private final float radius1;
    private final float radius2;
    private final float rotations;
    private final float offset;

    @Override
    @NotNull
    public Vec3d get(float i) {
        double radius = (double)this.radius1 + (double)(this.radius2 - this.radius1) * (double)i;
        return Rotations3D.rotate(this.transform, radius * (double)MathHelper.func_76134_b((float)(i * this.radiansPerUnit)), (double)i * this.len, radius * (double)MathHelper.func_76126_a((float)(i * this.radiansPerUnit)));
    }

    @NotNull
    public final Vec3d getPoint1() {
        return this.point1;
    }

    @NotNull
    public final Vec3d getPoint2() {
        return this.point2;
    }

    public final float getRadius1() {
        return this.radius1;
    }

    public final float getRadius2() {
        return this.radius2;
    }

    public final float getRotations() {
        return this.rotations;
    }

    public final float getOffset() {
        return this.offset;
    }

    public InterpHelix(@NotNull Vec3d point1, @NotNull Vec3d point2, float radius1, float radius2, float rotations, float offset) {
        Intrinsics.checkParameterIsNotNull((Object)point1, (String)"point1");
        Intrinsics.checkParameterIsNotNull((Object)point2, (String)"point2");
        this.point1 = point1;
        this.point2 = point2;
        this.radius1 = radius1;
        this.radius2 = radius2;
        this.rotations = rotations;
        this.offset = offset;
        this.disp = CommonUtilMethods.minus(this.point2, this.point1);
        this.len = this.disp.func_72433_c();
        this.radiansPerUnit = (float)((double)(this.rotations * (float)2) * Math.PI);
        this.transform = Rotations3D.withTranslation(Rotations3D.rotationMatrix(new Vec3d(0.0, 1.0, 0.0), this.disp), this.point1);
    }

    @Override
    @NotNull
    public InterpFunction<Vec3d> reverse() {
        return InterpFunction.DefaultImpls.reverse(this);
    }

    @Override
    @NotNull
    public List<Vec3d> list(int points) {
        return InterpFunction.DefaultImpls.list(this, points);
    }
}

