/*
 * Decompiled with CFR 0.152.
 */
package hqbanana.skycompression.base.tile;

import com.bartz24.skyresources.base.gui.ItemHandlerSpecial;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import hqbanana.skycompression.AdditionalProcessRecipesManager;
import hqbanana.skycompression.base.tile.TileGenericPower;
import hqbanana.skycompression.config.AdditionalConfigOptions;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;

public class TileCompressedRockCrusher
extends TileGenericPower
implements ITickable {
    private NonNullList<ItemStack> bufferStacks = NonNullList.func_191196_a();
    private int powerUsage;
    private int currentProgress;

    public TileCompressedRockCrusher() {
        super("compressedRockCrusher", 1000000, 6000, 0, 4, new int[]{1, 2, 3}, new int[]{0});
        this.powerUsage = AdditionalConfigOptions.machineSettings.compressedRockCrusherPowerUsage;
        this.setInventory(new ItemHandlerSpecial(4, new int[]{1, 2, 3}, new int[]{0}){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileCompressedRockCrusher.this.func_70296_d();
            }
        });
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.bufferStacks.size() > 0 && !this.FullOutput()) {
                this.AddToOutput(1);
                this.AddToOutput(2);
                this.AddToOutput(3);
            } else {
                boolean hasRecipes = this.HasRecipes();
                if (this.currentProgress < 100 && this.getEnergyStored() >= this.powerUsage && hasRecipes && this.bufferStacks.size() == 0) {
                    this.internalExtractEnergy(this.powerUsage, false);
                    this.currentProgress += AdditionalConfigOptions.machineSettings.compressedRockCrusherSpeed;
                } else if (!hasRecipes) {
                    this.currentProgress = 0;
                }
                if (this.currentProgress >= 100 && hasRecipes) {
                    ProcessRecipe recipeMachine = new ProcessRecipe(Collections.singletonList(this.getInventory().getStackInSlot(0)), 2.1474836E9f, "compressedRockGrinder");
                    for (ProcessRecipe r : AdditionalProcessRecipesManager.compressedRockGrinderRecipes.getRecipes()) {
                        float chance;
                        if (r == null || !recipeMachine.isInputRecipeEqualTo(r, false)) continue;
                        for (chance = r.getIntParameter() * 3.0f; chance >= 1.0f; chance -= 1.0f) {
                            this.bufferStacks.add((Object)((ItemStack)r.getOutputs().get(0)).func_77946_l());
                        }
                        if (!(this.field_145850_b.field_73012_v.nextFloat() <= chance)) continue;
                        this.bufferStacks.add((Object)((ItemStack)r.getOutputs().get(0)).func_77946_l());
                    }
                    this.getInventory().getStackInSlot(0).func_190918_g(1);
                    this.currentProgress = 0;
                }
            }
            this.func_70296_d();
        }
    }

    public void AddToOutput(int slot) {
        if (this.bufferStacks.size() > 0) {
            ItemStack stack = this.getInventory().insertInternalItem(slot, (ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1), false);
            this.bufferStacks.set(this.bufferStacks.size() - 1, (Object)stack);
            if (((ItemStack)this.bufferStacks.get(this.bufferStacks.size() - 1)).func_190926_b()) {
                this.bufferStacks.remove(this.bufferStacks.size() - 1);
            }
        }
    }

    public boolean FullOutput() {
        return !this.getInventory().getStackInSlot(1).func_190926_b() && !this.getInventory().getStackInSlot(2).func_190926_b() && !this.getInventory().getStackInSlot(3).func_190926_b();
    }

    public boolean HasRecipes() {
        if (this.getInventory().getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ProcessRecipe recipeMachine = new ProcessRecipe(Collections.singletonList(this.getInventory().getStackInSlot(0)), 2.1474836E9f, "compressedRockGrinder");
        for (ProcessRecipe r : AdditionalProcessRecipesManager.compressedRockGrinderRecipes.getRecipes()) {
            if (r == null || !recipeMachine.isInputRecipeEqualTo(r, false)) continue;
            return true;
        }
        return false;
    }

    public int GetProgress() {
        return this.currentProgress;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("buffer", (NBTBase)this.BufferListWrite());
        compound.func_74768_a("progress", this.currentProgress);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.BufferListRead(compound.func_74775_l("buffer"));
        this.currentProgress = compound.func_74762_e("progress");
    }

    public NBTTagCompound BufferListWrite() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.bufferStacks.size(); ++i) {
            if (((ItemStack)this.bufferStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.bufferStacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        return nbt;
    }

    public void BufferListRead(NBTTagCompound nbt) {
        NBTTagList nbtTagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = nbtTagList.func_150305_b(i);
            this.bufferStacks.add((Object)new ItemStack(itemTags));
        }
    }
}

