/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.client;

import com.latmod.mods.tesslocator.block.BlockTesslocator;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.item.TesslocatorItems;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="tesslocator", value={Side.CLIENT})
public class TesslocatorClientEventHandler {
    private static void registerModel(Item item, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.BASIC_ITEM_TESSLOCATOR, "inventory");
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.BASIC_FLUID_TESSLOCATOR, "inventory");
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.BASIC_ENERGY_TESSLOCATOR, "inventory");
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.ADVANCED_ITEM_TESSLOCATOR, "inventory");
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.ADVANCED_FLUID_TESSLOCATOR, "inventory");
        TesslocatorClientEventHandler.registerModel(TesslocatorItems.ADVANCED_ENERGY_TESSLOCATOR, "inventory");
    }

    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            TileEntity tileEntity;
            if (world != null && pos != null && tintIndex >= 0 && (tileEntity = world.func_175625_s(pos)) instanceof TileTesslocator) {
                TileTesslocator tile = (TileTesslocator)tileEntity;
                if (tile.parts[tintIndex % 6] != null) {
                    return 0xFF000000 | tile.parts[tintIndex % 6].getColor(tintIndex / 6);
                }
            }
            return -1;
        }, new Block[]{BlockTesslocator.INSTANCE});
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((stack, tintIndex) -> {
            int colors = stack.func_77942_o() ? stack.func_77978_p().func_74771_c("colors") & 0xFF : 0;
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)(colors >> tintIndex * 4 & 0xF)).func_193350_e();
        }, new Item[]{TesslocatorItems.ADVANCED_ITEM_TESSLOCATOR, TesslocatorItems.ADVANCED_FLUID_TESSLOCATOR, TesslocatorItems.ADVANCED_ENERGY_TESSLOCATOR});
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            TileEntity tileEntity;
            if (world != null && pos != null && tintIndex >= 0 && (tileEntity = world.func_175625_s(pos)) instanceof TileTesslocator) {
                TileTesslocator tile = (TileTesslocator)tileEntity;
                if (tile.parts[tintIndex % 6] != null) {
                    return 0xFF000000 | tile.parts[tintIndex % 6].getColor(tintIndex / 6);
                }
            }
            return -1;
        }, new Block[0]);
    }
}

