/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.data;

import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.AdvancedTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import com.latmod.mods.tesslocator.data.TessNetKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TessNet {
    public static TessNet SERVER = null;
    private boolean isDirty = true;
    private AdvancedTesslocatorPart[] advancedParts = null;
    private Map<TessNetKey, AdvancedTesslocatorPart[]> keyMap = new HashMap<TessNetKey, AdvancedTesslocatorPart[]>();

    public void markDirty() {
        this.isDirty = true;
    }

    public void update() {
        if (!this.isDirty) {
            return;
        }
        this.advancedParts = null;
        this.keyMap = null;
        this.isDirty = false;
    }

    public AdvancedTesslocatorPart[] getAll() {
        if (this.advancedParts != null) {
            return this.advancedParts;
        }
        ArrayList<AdvancedTesslocatorPart> list = new ArrayList<AdvancedTesslocatorPart>();
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            for (TileEntity tileEntity : world.field_147482_g) {
                if (!(tileEntity instanceof TileTesslocator) || tileEntity.func_145837_r()) continue;
                for (TesslocatorPart part : ((TileTesslocator)tileEntity).parts) {
                    if (!(part instanceof AdvancedTesslocatorPart)) continue;
                    list.add((AdvancedTesslocatorPart)part);
                }
            }
        }
        this.advancedParts = list.toArray(new AdvancedTesslocatorPart[0]);
        return this.advancedParts;
    }

    public AdvancedTesslocatorPart[] get(TessNetKey key) {
        AdvancedTesslocatorPart[] array;
        if (this.keyMap == null) {
            this.keyMap = new HashMap<TessNetKey, AdvancedTesslocatorPart[]>();
        }
        if ((array = this.keyMap.get(key)) == null) {
            ArrayList<AdvancedTesslocatorPart> list = new ArrayList<AdvancedTesslocatorPart>();
            for (AdvancedTesslocatorPart part : this.getAll()) {
                if (!key.equals(part.getKey())) continue;
                list.add(part);
            }
            array = list.toArray(new AdvancedTesslocatorPart[0]);
            this.keyMap.put(key, array);
        }
        return array;
    }
}

