/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.filters;

import com.latmod.mods.itemfilters.api.StringValueFilterVariant;
import com.latmod.mods.itemfilters.filters.StringValueFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryFilter
extends StringValueFilter {
    private int oreID = -1;

    @Override
    public String getID() {
        return "ore";
    }

    @Override
    public void setValue(String v) {
        super.setValue(v);
        this.oreID = -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Collection<StringValueFilterVariant> getValueVariants() {
        ArrayList<StringValueFilterVariant> variants = new ArrayList<StringValueFilterVariant>();
        for (String s : OreDictionary.getOreNames()) {
            NonNullList list = OreDictionary.getOres((String)s);
            if (list.isEmpty()) continue;
            StringValueFilterVariant variant = new StringValueFilterVariant(s);
            variant.icon = ((ItemStack)list.get(0)).func_77946_l();
            if (variant.icon.func_77952_i() == Short.MAX_VALUE) {
                variant.icon.func_77964_b(0);
            }
            variants.add(variant);
        }
        return variants;
    }

    public int getOreID() {
        if (this.oreID == -1) {
            this.oreID = OreDictionary.getOreID((String)this.getValue());
        }
        return this.oreID;
    }

    @Override
    public boolean filter(ItemStack stack) {
        if (this.getValue().isEmpty() || stack.func_190926_b()) {
            return false;
        }
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (i != this.getOreID()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getValidItems(List<ItemStack> list) {
        if (this.cachedItems == null) {
            this.cachedItems = new ArrayList();
            if (!this.getValue().isEmpty()) {
                for (ItemStack stack : OreDictionary.getOres((String)this.getValue())) {
                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                        NonNullList list1 = NonNullList.func_191196_a();
                        stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list1);
                        this.cachedItems.addAll(list1);
                        continue;
                    }
                    this.cachedItems.add(stack);
                }
            }
            this.cachedItems = OreDictionaryFilter.compress(this.cachedItems);
        }
        if (!this.cachedItems.isEmpty()) {
            list.addAll(this.cachedItems);
        }
    }
}

