/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.gui.GuiContainerBase;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.container.ContainerFluidHatch;
import hellfirepvp.modularmachinery.common.network.PktInteractFluidTankGui;
import hellfirepvp.modularmachinery.common.tiles.base.TileFluidTank;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiContainerFluidHatch
extends GuiContainerBase<ContainerFluidHatch> {
    public static final ResourceLocation TEXTURES_FLUID_HATCH = new ResourceLocation("modularmachinery", "textures/gui/guibar.png");
    private TileFluidTank tank;

    public GuiContainerFluidHatch(TileFluidTank tileFluidTank, EntityPlayer opening) {
        super(new ContainerFluidHatch(tileFluidTank, opening));
        this.tank = tileFluidTank;
    }

    @Override
    protected void setWidthHeight() {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ItemStack held;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetZ = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseButton == 0 && mouseX >= 15 + offsetX && mouseX <= 35 + offsetX && mouseY >= 10 + offsetZ && mouseY <= 71 + offsetZ && !(held = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b()) {
            ModularMachinery.NET_CHANNEL.sendToServer((IMessage)new PktInteractFluidTankGui());
        }
    }

    protected void func_191948_b(int x, int z) {
        super.func_191948_b(x, z);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetZ = (this.field_146295_m - this.field_147000_g) / 2;
        if (x >= 15 + offsetX && x <= 35 + offsetX && z >= 10 + offsetZ && z <= 71 + offsetZ) {
            if (Mods.MEKANISM.isPresent()) {
                this.drawMekTooltip(x, z);
            } else {
                int amt;
                ArrayList text = Lists.newArrayList();
                FluidStack content = this.tank.getTank().getFluid();
                if (content == null || content.amount <= 0) {
                    text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.empty", (Object[])new Object[0]));
                    amt = 0;
                } else {
                    text.add(content.getLocalizedName());
                    amt = content.amount;
                }
                text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.tank", (Object[])new Object[]{String.valueOf(amt), String.valueOf(this.tank.getTank().getCapacity())}));
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                this.drawHoveringText(text, x, z, font == null ? this.field_146289_q : font);
            }
        }
    }

    @Optional.Method(modid="mekanism")
    private void drawMekTooltip(int x, int z) {
        ArrayList text = Lists.newArrayList();
        FluidStack content = this.tank.getTank().getFluid();
        if (content == null || content.amount <= 0) {
            if (this.tank.getTank() instanceof HybridGasTank) {
                GasStack gasContent = ((HybridGasTank)this.tank.getTank()).getGas();
                if (gasContent == null || gasContent.amount <= 0) {
                    text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.empty", (Object[])new Object[0]));
                    int amt = 0;
                    text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.tank", (Object[])new Object[]{String.valueOf(amt), String.valueOf(this.tank.getTank().getCapacity())}));
                } else {
                    if (Mods.MEKANISM.isPresent()) {
                        text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.gas", (Object[])new Object[0]));
                    }
                    text.add(gasContent.getGas().getLocalizedName());
                    int amt = gasContent.amount;
                    text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.tank.gas", (Object[])new Object[]{String.valueOf(amt), String.valueOf(this.tank.getTank().getCapacity())}));
                }
            } else {
                text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.empty", (Object[])new Object[0]));
                int amt = 0;
                text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.tank", (Object[])new Object[]{String.valueOf(amt), String.valueOf(this.tank.getTank().getCapacity())}));
            }
        } else {
            if (Mods.MEKANISM.isPresent()) {
                text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.fluid", (Object[])new Object[0]));
            }
            text.add(content.getLocalizedName());
            int amt = content.amount;
            text.add(I18n.func_135052_a((String)"tooltip.fluidhatch.tank", (Object[])new Object[]{String.valueOf(amt), String.valueOf(this.tank.getTank().getCapacity())}));
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.drawHoveringText(text, x, z, font == null ? this.field_146289_q : font);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        FluidStack content = this.tank.getTank().getFluid();
        if (content != null && content.amount > 0) {
            int fluidColor = content.getFluid().getColor(content);
            float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(fluidColor & 0xFF) / 255.0f;
            float percFilled = (float)content.amount / (float)this.tank.getTank().getCapacity();
            percFilled = MathHelper.func_76131_a((float)percFilled, (float)0.0f, (float)1.0f);
            int pxFilled = MathHelper.func_76123_f((float)(percFilled * 61.0f));
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            ResourceLocation rl = content.getFluid().getStill(content);
            TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().getTextureExtry(rl.toString());
            if (tas == null) {
                tas = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(15, 71 - pxFilled, tas, 20, pxFilled);
        } else if (Mods.MEKANISM.isPresent()) {
            this.drawMekGasContent();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_FLUID_HATCH);
        this.func_73729_b(15, 10, 176, 0, 20, 61);
    }

    @Optional.Method(modid="mekanism")
    private void drawMekGasContent() {
        GasStack gasContent;
        if (this.tank.getTank() instanceof HybridGasTank && (gasContent = ((HybridGasTank)this.tank.getTank()).getGas()) != null && gasContent.amount > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float percFilled = (float)gasContent.amount / (float)this.tank.getTank().getCapacity();
            percFilled = MathHelper.func_76131_a((float)percFilled, (float)0.0f, (float)1.0f);
            int pxFilled = MathHelper.func_76123_f((float)(percFilled * 61.0f));
            TextureAtlasSprite tas = gasContent.getGas().getSprite();
            if (tas == null) {
                tas = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(15, 71 - pxFilled, tas, 20, pxFilled);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_FLUID_HATCH);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

