/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockCasing;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockCustomName;
import hellfirepvp.modularmachinery.common.block.BlockDynamicColor;
import hellfirepvp.modularmachinery.common.block.BlockEnergyInputHatch;
import hellfirepvp.modularmachinery.common.block.BlockEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.block.BlockFluidInputHatch;
import hellfirepvp.modularmachinery.common.block.BlockFluidOutputHatch;
import hellfirepvp.modularmachinery.common.block.BlockInputBus;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.block.BlockOutputBus;
import hellfirepvp.modularmachinery.common.item.ItemBlockCustomName;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponentCustomName;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyInputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileEnergyOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileFluidInputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileFluidOutputHatch;
import hellfirepvp.modularmachinery.common.tiles.TileItemInputBus;
import hellfirepvp.modularmachinery.common.tiles.TileItemOutputBus;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class RegistryBlocks {
    private static List<Block> blockModelRegister = Lists.newArrayList();
    public static List<BlockDynamicColor> pendingIBlockColorBlocks = new LinkedList<BlockDynamicColor>();

    public static void initialize() {
        RegistryBlocks.registerBlocks();
        RegistryBlocks.registerTiles();
        RegistryBlocks.registerBlockModels();
    }

    private static void registerBlocks() {
        BlocksMM.blockController = RegistryBlocks.prepareRegister(new BlockController());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockController);
        BlocksMM.blockCasing = RegistryBlocks.prepareRegister(new BlockCasing());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.blockCasing);
        BlocksMM.itemInputBus = RegistryBlocks.prepareRegister(new BlockInputBus());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.itemInputBus);
        BlocksMM.itemOutputBus = RegistryBlocks.prepareRegister(new BlockOutputBus());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.itemOutputBus);
        BlocksMM.fluidInputHatch = RegistryBlocks.prepareRegister(new BlockFluidInputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.fluidInputHatch);
        BlocksMM.fluidOutputHatch = RegistryBlocks.prepareRegister(new BlockFluidOutputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.fluidOutputHatch);
        BlocksMM.energyInputHatch = RegistryBlocks.prepareRegister(new BlockEnergyInputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.energyInputHatch);
        BlocksMM.energyOutputHatch = RegistryBlocks.prepareRegister(new BlockEnergyOutputHatch());
        RegistryBlocks.prepareItemBlockRegister((Block)BlocksMM.energyOutputHatch);
    }

    private static void registerTiles() {
        RegistryBlocks.registerTile(TileColorableMachineComponent.class);
        RegistryBlocks.registerTile(TileMachineController.class);
        RegistryBlocks.registerTile(TileFluidInputHatch.class);
        RegistryBlocks.registerTile(TileFluidOutputHatch.class);
        RegistryBlocks.registerTile(TileItemOutputBus.class);
        RegistryBlocks.registerTile(TileItemInputBus.class);
        RegistryBlocks.registerTile(TileEnergyInputHatch.class);
        RegistryBlocks.registerTile(TileEnergyOutputHatch.class);
    }

    private static void registerBlockModels() {
        for (Block block : blockModelRegister) {
            ModularMachinery.proxy.registerBlockModel(block);
        }
    }

    private static void registerTile(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    private static void registerTile(Class<? extends TileEntity> tile) {
        RegistryBlocks.registerTile(tile, tile.getSimpleName().toLowerCase());
    }

    private static void prepareItemBlockRegister(Block block) {
        if (block instanceof BlockMachineComponent) {
            if (block instanceof BlockCustomName) {
                RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponentCustomName(block));
            } else {
                RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponent(block));
            }
        } else if (block instanceof BlockCustomName) {
            RegistryBlocks.prepareItemBlockRegister(new ItemBlockCustomName(block));
        } else {
            RegistryBlocks.prepareItemBlockRegister(new ItemBlock(block));
        }
    }

    private static <T extends ItemBlock> T prepareItemBlockRegister(T item) {
        String name = item.func_179223_d().getClass().getSimpleName().toLowerCase();
        ((Item)item.setRegistryName(name)).func_77655_b("modularmachinery." + name);
        RegistryItems.itemBlocks.add((Item)item);
        return item;
    }

    private static <T extends Block> T prepareRegister(T block) {
        String name = block.getClass().getSimpleName().toLowerCase();
        ((Block)block.setRegistryName(name)).func_149663_c("modularmachinery." + name);
        blockModelRegister.add(block);
        CommonProxy.registryPrimer.register(block);
        if (block instanceof BlockDynamicColor) {
            pendingIBlockColorBlocks.add((BlockDynamicColor)block);
        }
        return block;
    }
}

