/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgriAdapterizer<T>
implements IAgriAdapterizer<T> {
    private final Deque<IAgriAdapter<T>> adapters = new ConcurrentLinkedDeque<IAgriAdapter<T>>();

    @Override
    public boolean hasAdapter(@Nullable Object obj) {
        return this.adapters.stream().anyMatch(a -> a.accepts(obj));
    }

    @Override
    public boolean hasAdapter(@Nullable IAgriAdapter<T> adapter) {
        return this.adapters.contains(adapter);
    }

    @Override
    @Nonnull
    public Optional<IAgriAdapter<T>> getAdapter(@Nullable Object obj) {
        return this.adapters.stream().filter(a -> a.accepts(obj)).findFirst();
    }

    @Override
    public boolean registerAdapter(@Nonnull IAgriAdapter<T> adapter) {
        Preconditions.checkNotNull(adapter);
        if (!this.adapters.contains(adapter)) {
            this.adapters.push(adapter);
            return true;
        }
        return false;
    }

    @Override
    public boolean unregisterAdapter(@Nonnull IAgriAdapter<T> adapter) {
        Preconditions.checkNotNull(adapter);
        return this.adapters.removeFirstOccurrence(adapter);
    }
}

