/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.alchemy.tile;

import com.bartz24.skyresources.alchemy.FusionCatalysts;
import com.bartz24.skyresources.base.gui.ItemHandlerSpecial;
import com.bartz24.skyresources.base.tile.TileItemInventory;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class TileAlchemyFusionTable
extends TileItemInventory
implements ITickable {
    private NonNullList<ItemStack> filter = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private double yieldAmount;
    private float yieldRate;
    private float curCatalystYield;
    private float curCatalystLeft;
    private int curProgress;
    private ItemStack outputStack = ItemStack.field_190927_a;

    public TileAlchemyFusionTable() {
        super("fusionTable", 11, new int[]{10}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        this.setInventory(new ItemHandlerSpecial(11, new int[]{10}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileAlchemyFusionTable.this.func_70296_d();
            }

            @Override
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return !FusionCatalysts.isCatalyst(stack) ? stack : super.insertItem(slot, stack, simulate);
                }
                if (slot < 10 && !stack.func_77969_a((ItemStack)TileAlchemyFusionTable.this.filter.get(slot - 1))) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        });
    }

    private void updateCrafting() {
        ProcessRecipe recipe;
        if (this.outputStack.func_190926_b() && (recipe = ProcessRecipeManager.fusionRecipes.getRecipe(this.getStacksForRecipe(), 2.1474836E9f, false, false)) != null) {
            this.outputStack = recipe.getOutputs().get(0);
            this.yieldRate = recipe.getIntParameter();
            block0: for (int i = 0; i < 9; ++i) {
                for (Object o : recipe.getInputs()) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    if (o instanceof String && OreDictionary.getOres((String)((String)o)).size() > 0) {
                        for (ItemStack s : OreDictionary.getOres((String)((String)o))) {
                            stacks.add(s);
                        }
                    } else if (o instanceof ItemStack) {
                        stacks.add((ItemStack)o);
                    }
                    boolean success = false;
                    for (ItemStack s : stacks) {
                        if (s.func_190926_b() || !s.func_77969_a(this.getInventory().getStackInSlot(i + 1))) continue;
                        this.getInventory().getStackInSlot(i + 1).func_190918_g(s.func_190916_E());
                        if (this.getInventory().getStackInSlot(i + 1).func_190926_b()) {
                            this.getInventory().setStackInSlot(i + 1, ItemStack.field_190927_a);
                        }
                        success = true;
                        break;
                    }
                    if (!success) continue;
                    continue block0;
                }
            }
        }
        if (this.curProgress < 100 && !this.outputStack.func_190926_b() && this.curCatalystLeft >= this.yieldRate && this.getInventory().insertInternalItem(10, this.outputStack.func_77946_l(), true).func_190926_b()) {
            ++this.curProgress;
            this.curCatalystLeft -= this.yieldRate;
            this.yieldAmount = (double)Math.round((this.yieldAmount + (double)this.curCatalystYield / 100.0) * 10000.0) / 10000.0;
            if (this.yieldAmount >= 1.0) {
                ItemStack output = this.outputStack.func_77946_l();
                output.func_190920_e((int)((double)output.func_190916_E() * Math.floor(this.yieldAmount)));
                this.getInventory().insertInternalItem(10, output, false);
                this.yieldAmount -= Math.floor(this.yieldAmount);
            }
        }
        if (!this.outputStack.func_190926_b() && this.curCatalystLeft < this.yieldRate && FusionCatalysts.isCatalyst(this.getInventory().getStackInSlot(0))) {
            this.curCatalystLeft += 1.0f;
            this.curCatalystYield = FusionCatalysts.getCatalystValue(this.getInventory().getStackInSlot(0));
            this.getInventory().getStackInSlot(0).func_190918_g(1);
            if (this.getInventory().getStackInSlot(0).func_190926_b()) {
                this.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
        if (this.curProgress >= (int)(800.0f / (float)ConfigOptions.machineSettings.fusionSpeed)) {
            this.curProgress = 0;
            this.outputStack = ItemStack.field_190927_a;
            this.yieldRate = 0.0f;
        }
    }

    private List<Object> getStacksForRecipe() {
        ArrayList<Object> stacks = new ArrayList<Object>();
        for (int i = 0; i < 9; ++i) {
            if (this.getInventory().getStackInSlot(i + 1).func_190926_b()) continue;
            stacks.add(this.getInventory().getStackInSlot(i + 1));
        }
        return stacks;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateCrafting();
            this.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74780_a("yield", this.yieldAmount);
        compound.func_74776_a("yieldRate", this.yieldRate);
        compound.func_74782_a("output", (NBTBase)this.outputStack.func_77955_b(new NBTTagCompound()));
        compound.func_74776_a("itemYield", this.curCatalystYield);
        compound.func_74776_a("itemLeft", this.curCatalystLeft);
        compound.func_74768_a("progress", this.curProgress);
        compound.func_74782_a("filter", (NBTBase)this.writeFilter());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.yieldAmount = compound.func_74769_h("yield");
        this.yieldRate = compound.func_74760_g("yieldRate");
        this.outputStack = new ItemStack(compound.func_74775_l("output"));
        this.curCatalystYield = compound.func_74760_g("itemYield");
        this.curCatalystLeft = compound.func_74760_g("itemLeft");
        this.curProgress = compound.func_74762_e("progress");
        this.readFilter(compound.func_74775_l("filter"));
    }

    public NBTTagCompound writeFilter() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.filter.size(); ++i) {
            if (((ItemStack)this.filter.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.filter.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.filter.size());
        return nbt;
    }

    public void readFilter(NBTTagCompound nbt) {
        this.filter = NonNullList.func_191197_a((int)(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.filter.size()), (Object)ItemStack.field_190927_a);
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.filter.size()) continue;
            this.filter.set(slot, (Object)new ItemStack(itemTags));
        }
    }

    public void setFilter(int index, ItemStack val) {
        this.filter.set(index, (Object)val);
    }

    public ItemStack getFilterStack(int index) {
        return (ItemStack)this.filter.get(index);
    }

    public int getProgress() {
        return this.curProgress;
    }

    public void setCurYield(double amt) {
        this.yieldAmount = amt;
    }

    public double getCurYield() {
        return this.yieldAmount;
    }

    public float getCurItemYield() {
        return this.curCatalystYield;
    }

    public void setCurItemLeft(float amt) {
        this.curCatalystLeft = amt;
    }

    public float getCurItemLeft() {
        return this.curCatalystLeft;
    }
}

