/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import funwayguy.skygrid.util.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class GridBlock {
    public int weight = 10;
    private ResourceLocation name;
    private int meta;
    private IBlockState block;
    public List<GridPlant> plants = new ArrayList<GridPlant>();
    public List<Integer> biomes = new ArrayList<Integer>();

    public GridBlock(JsonObject json) {
        this.readFromJson(json);
    }

    public GridBlock(IBlockState state) {
        this.block = state != null ? state : Blocks.field_150350_a.func_176223_P();
        this.meta = state.func_177230_c().func_176201_c(state);
        this.name = state.func_177230_c().getRegistryName();
    }

    public GridBlock(Block b) {
        this(b.func_176223_P());
    }

    public GridBlock(Block b, int meta) {
        this(b.func_176203_a(meta));
    }

    public GridBlock(String name, int meta) {
        this.name = new ResourceLocation(name);
        this.meta = meta;
    }

    public void addPlant(IBlockState state) {
        this.plants.add(new GridPlant(state));
    }

    public void addPlant(Block b) {
        this.addPlant(b.func_176223_P());
    }

    public void addPlant(Block b, int meta) {
        this.addPlant(b.func_176203_a(meta));
    }

    public void addPlant(String name, int meta) {
        this.plants.add(new GridPlant(name, meta));
    }

    public boolean hasPlants() {
        return this.plants != null && this.plants.size() > 0;
    }

    public IBlockState getState() {
        if (this.block != null) {
            return this.block;
        }
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)this.name);
        this.block = b != Blocks.field_150350_a ? (this.meta < 0 ? b.func_176223_P() : b.func_176203_a(this.meta)) : Blocks.field_150348_b.func_176223_P();
        return this.block;
    }

    public JsonObject writeToJson(JsonObject json) {
        json.addProperty("block", this.name.toString());
        json.addProperty("meta", (Number)this.meta);
        json.addProperty("weight", (Number)this.weight);
        JsonArray pList = new JsonArray();
        for (GridPlant plant : this.plants) {
            JsonObject tmp = new JsonObject();
            tmp.addProperty("block", plant.name.toString());
            tmp.addProperty("meta", (Number)plant.meta);
            pList.add((JsonElement)tmp);
        }
        json.add("plants", (JsonElement)pList);
        JsonArray bList = new JsonArray();
        for (int id : this.biomes) {
            Biome b = Biome.func_150568_d((int)id);
            if (b == null) continue;
            JsonPrimitive jp = new JsonPrimitive(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)b)).toString());
            bList.add((JsonElement)jp);
        }
        json.add("biomes", (JsonElement)bList);
        return json;
    }

    public void readFromJson(JsonObject json) {
        this.name = new ResourceLocation(JsonHelper.GetString(json, "block", "minecraft:stone"));
        this.meta = JsonHelper.GetNumber(json, "meta", -1).intValue();
        this.weight = JsonHelper.GetNumber(json, "weight", this.weight).intValue();
        this.plants = new ArrayList<GridPlant>();
        for (JsonElement e : JsonHelper.GetArray(json, "plants")) {
            if (e == null || !e.isJsonObject()) continue;
            JsonObject tmp = e.getAsJsonObject();
            String pn = JsonHelper.GetString(tmp, "block", "minecraft:stone");
            int pm = JsonHelper.GetNumber(tmp, "meta", -1).intValue();
            this.plants.add(new GridPlant(pn, pm));
        }
        this.biomes = new ArrayList<Integer>();
        for (JsonElement e : JsonHelper.GetArray(json, "biomes")) {
            int bID;
            String bName;
            Biome b;
            if (e == null || !e.isJsonPrimitive() || (b = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(bName = e.getAsString()))) == null || this.biomes.contains(bID = Biome.func_185362_a((Biome)b))) continue;
            this.biomes.add(bID);
        }
    }

    public static class GridPlant {
        private final ResourceLocation name;
        private final int meta;
        private IBlockState block;

        public GridPlant(IBlockState state) {
            this.block = state != null ? state : Blocks.field_150350_a.func_176223_P();
            this.meta = state.func_177230_c().func_176201_c(state);
            this.name = state.func_177230_c().getRegistryName();
        }

        public GridPlant(String name, int meta) {
            this.name = new ResourceLocation(name);
            this.meta = meta;
        }

        public IBlockState getState() {
            if (this.block != null) {
                return this.block;
            }
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)this.name);
            this.block = b != Blocks.field_150350_a ? (this.meta < 0 ? b.func_176223_P() : b.func_176203_a(this.meta)) : Blocks.field_150348_b.func_176223_P();
            return this.block;
        }
    }
}

