/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.buildcraft;

import buildcraft.energy.BCEnergyFluids;
import buildcraft.lib.fluid.FuelRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemDynamicCell;

@RebornRegistry(modOnly="buildcraftenergy", modID="techreborn")
public class BuildCraftEnergyCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="buildcraft", key="EnableDistillationTowerBuildCraftRecipes", comment="Enable distillation tower recipes related to BuildCraft fuels")
    public static boolean enableDistillationTowerBuildCraftRecipes = true;
    @ConfigRegistry(config="compat", category="buildcraft", key="EnableBuildcraftFuels", comment="Allow BuildCraft fuels to be used in fuel generators")
    public static boolean allowBuildCraftFuels = true;

    public void init(FMLInitializationEvent event) {
        if (enableDistillationTowerBuildCraftRecipes) {
            RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemDynamicCell.getCellWithFluid((Fluid)BCEnergyFluids.crudeOil[0], (int)16), (Object)ItemDynamicCell.getEmptyCell((int)33), RecipeMethods.getMaterial((String)"diesel", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"sulfuricAcid", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"glyceryl", (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"methane", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), 16000, 16));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (allowBuildCraftFuels) {
            FuelRegistry.INSTANCE.getFuels().forEach(fuel -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.THERMAL, (Fluid)fuel.getFluid().getFluid(), (int)((int)(fuel.getPowerPerCycle() / 200000L))));
        }
    }
}

