/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.inscriber;

import appeng.api.features.IInscriberRecipe;
import appeng.api.features.IInscriberRecipeBuilder;
import appeng.api.features.IInscriberRegistry;
import appeng.api.features.InscriberProcessType;
import appeng.core.features.registries.inscriber.InscriberRecipe;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public final class InscriberRegistry
implements IInscriberRegistry {
    private final Set<IInscriberRecipe> recipes;
    private final Set<ItemStack> optionals;
    private final Set<ItemStack> inputs = new HashSet<ItemStack>();

    public InscriberRegistry() {
        this.optionals = new HashSet<ItemStack>();
        this.recipes = new HashSet<IInscriberRecipe>();
    }

    @Override
    @Nonnull
    public Collection<IInscriberRecipe> getRecipes() {
        return Collections.unmodifiableCollection(this.recipes);
    }

    @Override
    @Nonnull
    public Set<ItemStack> getOptionals() {
        return this.optionals;
    }

    @Override
    @Nonnull
    public Set<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public IInscriberRecipeBuilder builder() {
        return new Builder();
    }

    @Override
    public boolean addRecipe(IInscriberRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Tried to add (null) as inscriber recipe to the registry.");
        if (this.recipes.add(recipe)) {
            recipe.getTopOptional().ifPresent(this.optionals::add);
            recipe.getBottomOptional().ifPresent(this.optionals::add);
            this.inputs.addAll(recipe.getInputs());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRecipe(IInscriberRecipe toBeRemovedRecipe) {
        Preconditions.checkNotNull((Object)toBeRemovedRecipe, (Object)"Tried to remove (null) from the registry.");
        boolean changed = false;
        Iterator<IInscriberRecipe> iterator = this.recipes.iterator();
        while (iterator.hasNext()) {
            IInscriberRecipe recipe = iterator.next();
            if (!recipe.equals(toBeRemovedRecipe)) continue;
            changed = true;
            iterator.remove();
        }
        return changed;
    }

    private static final class Builder
    implements IInscriberRecipeBuilder {
        private List<ItemStack> inputs;
        private ItemStack output;
        private ItemStack topOptional;
        private ItemStack bottomOptional;
        private InscriberProcessType type;

        private Builder() {
        }

        @Override
        @Nonnull
        public Builder withInputs(@Nonnull Collection<ItemStack> inputs) {
            Preconditions.checkNotNull(inputs);
            Preconditions.checkArgument((!inputs.isEmpty() ? 1 : 0) != 0);
            this.inputs = new ArrayList<ItemStack>(inputs.size());
            this.inputs.addAll(inputs);
            return this;
        }

        @Override
        @Nonnull
        public Builder withOutput(@Nonnull ItemStack output) {
            Preconditions.checkNotNull((Object)output);
            Preconditions.checkArgument((!output.func_190926_b() ? 1 : 0) != 0);
            this.output = output;
            return this;
        }

        @Override
        @Nonnull
        public Builder withTopOptional(@Nonnull ItemStack topOptional) {
            Preconditions.checkNotNull((Object)topOptional);
            Preconditions.checkArgument((!topOptional.func_190926_b() ? 1 : 0) != 0);
            this.topOptional = topOptional;
            return this;
        }

        @Override
        @Nonnull
        public Builder withBottomOptional(@Nonnull ItemStack bottomOptional) {
            Preconditions.checkNotNull((Object)bottomOptional);
            Preconditions.checkArgument((!bottomOptional.func_190926_b() ? 1 : 0) != 0);
            this.bottomOptional = bottomOptional;
            return this;
        }

        @Override
        @Nonnull
        public Builder withProcessType(@Nonnull InscriberProcessType type) {
            Preconditions.checkNotNull((Object)((Object)type));
            this.type = type;
            return this;
        }

        @Override
        @Nonnull
        public IInscriberRecipe build() {
            Preconditions.checkState((this.inputs != null ? 1 : 0) != 0, (Object)"Input must be defined.");
            Preconditions.checkState((!this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"Input must have a size.");
            Preconditions.checkState((!this.output.func_190926_b() ? 1 : 0) != 0, (Object)"Output cannot be empty.");
            Preconditions.checkState((!this.topOptional.func_190926_b() || !this.bottomOptional.func_190926_b() ? 1 : 0) != 0, (Object)"One optional must be defined.");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Process type must be defined.");
            return new InscriberRecipe(this.inputs, this.output, this.topOptional, this.bottomOptional, this.type);
        }
    }
}

