/*
 * Decompiled with CFR 0.152.
 */
package hqbanana.skycompression.base.blocks;

import hqbanana.skycompression.base.blocks.BlockCompressedCactus;
import hqbanana.skycompression.base.blocks.CustomBlock;
import hqbanana.skycompression.config.AdditionalConfigOptions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockCompressedSnad
extends CustomBlock {
    public BlockCompressedSnad(String name, float hardness, float resistance, Material material, int harvestLevel) {
        super(name, hardness, resistance, material);
        this.setHarvestLevel("shovel", harvestLevel);
        this.func_149675_a(true);
    }

    public void func_180645_a(World world, BlockPos position, IBlockState state, Random random) {
        super.func_180645_a(world, position, state, random);
        Block blockAbove = world.func_180495_p(position.func_177984_a()).func_177230_c();
        if (blockAbove instanceof BlockCompressedCactus) {
            this.checkColumnOfPlant(world, position, random, blockAbove);
        } else if (blockAbove instanceof IPlantable) {
            blockAbove.func_180645_a(world, position.func_177984_a(), world.func_180495_p(position.func_177984_a()), random);
        }
    }

    private void checkColumnOfPlant(World world, BlockPos originalPosition, Random random, Block blockAbove) {
        Block nextPlantBlock;
        BlockPos nextPosition = originalPosition.func_177984_a();
        while ((nextPlantBlock = world.func_180495_p(nextPosition).func_177230_c()).getClass().equals(blockAbove.getClass())) {
            this.growthLoop(world, originalPosition, random, (IPlantable)blockAbove, nextPosition, nextPlantBlock);
            nextPosition = nextPosition.func_177984_a();
        }
    }

    private void growthLoop(World world, BlockPos orignalPosition, Random random, IPlantable blockAbove, BlockPos nextPosition, Block nextPlantBlock) {
        for (int growthAttempts = 0; growthAttempts < AdditionalConfigOptions.modsupport.snadSpeedIncrease; ++growthAttempts) {
            if (growthAttempts != 0 && !this.canSustainPlant(world.func_180495_p(orignalPosition), (IBlockAccess)world, orignalPosition, null, blockAbove)) continue;
            nextPlantBlock.func_180645_a(world, nextPosition, world.func_180495_p(nextPosition), random);
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        BlockPos plant = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        EnumPlantType plantType = plantable.getPlantType(world, plant);
        switch (plantType) {
            case Desert: {
                return true;
            }
        }
        return false;
    }
}

