/*
 * Decompiled with CFR 0.152.
 */
package hqbanana.skycompression.base.tools;

import com.bartz24.skyresources.RandomHelper;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.google.common.collect.Multimap;
import hqbanana.skycompression.AdditionalProcessRecipesManager;
import hqbanana.skycompression.ItemHelper;
import hqbanana.skycompression.SkyCompression;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCompressedRockGrinder
extends ItemPickaxe {
    private Item.ToolMaterial toolMaterial;
    private float damageVsEntity;

    public ItemCompressedRockGrinder(Item.ToolMaterial material, String name) {
        super(material);
        this.func_77655_b("sc." + name);
        this.setRegistryName(name);
        this.func_77637_a(SkyCompression.SKY_COMPRESSION_TAB);
        this.toolMaterial = material;
        this.func_77656_e(material.func_77997_a() * 5);
        this.damageVsEntity = 2.0f + material.func_78000_c();
        this.func_77625_d(1);
        this.setHarvestLevel("rockGrinder", material.func_77996_d());
        this.func_77656_e((int)((double)material.func_77997_a() * ConfigOptions.toolSettings.rockGrinderBaseDurability));
        ItemHelper.AddRockGrinder(this);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        ProcessRecipe recipe = new ProcessRecipe(Collections.singletonList(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state))), 2.1474836E9f, "compressedRockGrinder");
        for (ProcessRecipe r : AdditionalProcessRecipesManager.compressedRockGrinderRecipes.getRecipes()) {
            if (r == null || !recipe.isInputRecipeEqualTo(recipe, false)) continue;
            if (this.toolMaterial.func_77996_d() < block.getHarvestLevel(state)) {
                return 0.5f;
            }
            return this.toolMaterial.func_77998_b();
        }
        return 0.5f;
    }

    public boolean onBlockStartBreak(ItemStack item, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (item.func_96631_a(1, field_77697_d, null)) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        boolean worked = false;
        ProcessRecipe rec = new ProcessRecipe(Collections.singletonList(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state))), 2.1474836E9f, "compressedRockGrinder");
        for (ProcessRecipe r : AdditionalProcessRecipesManager.compressedRockGrinderRecipes.getRecipes()) {
            float chance;
            if (r == null || !rec.isInputRecipeEqualTo(r, false)) continue;
            worked = true;
            if (world.field_72995_K) continue;
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)item);
            for (chance = r.getIntParameter() * (((float)level + 3.0f) / 3.0f); chance >= 1.0f; chance -= 1.0f) {
                RandomHelper.spawnItemInWorld((World)world, (ItemStack)((ItemStack)r.getOutputs().get(0)).func_77946_l(), (BlockPos)pos);
            }
            if (!(field_77697_d.nextFloat() <= chance)) continue;
            RandomHelper.spawnItemInWorld((World)world, (ItemStack)((ItemStack)r.getOutputs().get(0)).func_77946_l(), (BlockPos)pos);
        }
        if (worked && !world.field_72995_K) {
            world.func_175655_b(pos, !worked);
        }
        return worked;
    }

    public Item.ToolMaterial GetMaterial() {
        return this.toolMaterial;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damageVsEntity, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }
}

