/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers.brackets;

import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspect;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.zenscript.IBracketHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import thaumcraft.api.aspects.Aspect;

@BracketHandler(priority=100)
@ZenRegister
@ModOnly(value="thaumcraft")
public class BracketHandlerAspect
implements IBracketHandler {
    private static final Map<String, Aspect> aspects = new HashMap<String, Aspect>();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(BracketHandlerAspect.class, (String)"getAspect", (Class[])new Class[]{String.class});

    public static void rebuildRegistry() {
        aspects.clear();
        Aspect.aspects.forEach(aspects::put);
    }

    public static CTAspectStack getAspect(String name) {
        return new CTAspectStack(new CTAspect((Aspect)Aspect.aspects.get(name)), 1);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        int fromIndex = 0;
        int toIndex = tokens.size();
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("aspect") && tokens.get(1).getValue().equals(":")) {
            fromIndex = 2;
        }
        return this.find(environment, tokens, fromIndex, toIndex);
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        String name = valueBuilder.toString();
        if (!aspects.containsKey(name)) {
            BracketHandlerAspect.rebuildRegistry();
        }
        if (aspects.containsKey(name)) {
            return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, valueBuilder.toString())});
        }
        return null;
    }
}

