/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.config.ModConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CombinationRecipe {
    protected ItemStack output;
    protected int cost;
    protected int perTick;
    protected ItemStack input;
    protected ArrayList<Object> pedestals = new ArrayList();
    protected ArrayList<String> inputList = new ArrayList();

    public CombinationRecipe(ItemStack output, int cost, ItemStack input, Object ... pedestals) {
        this(output, cost, ModConfig.confCraftingCoreRFRate, input, pedestals);
    }

    public CombinationRecipe(ItemStack output, int cost, int perTick, ItemStack input, Object ... pedestals) {
        this.output = output;
        this.cost = cost;
        this.perTick = perTick;
        this.input = input;
        LinkedHashMap<String, Integer> ingredients = new LinkedHashMap<String, Integer>();
        ingredients.put(input.func_82833_r(), 1);
        for (Object obj : pedestals) {
            ItemStack stack;
            if (obj instanceof ItemStack) {
                stack = ((ItemStack)obj).func_77946_l();
                this.pedestals.add(stack);
                this.putIngredient(ingredients, stack.func_82833_r());
                continue;
            }
            if (obj instanceof Item) {
                stack = new ItemStack((Item)obj);
                this.pedestals.add(stack);
                this.putIngredient(ingredients, stack.func_82833_r());
                continue;
            }
            if (obj instanceof Block) {
                stack = new ItemStack((Block)obj);
                this.pedestals.add(stack);
                this.putIngredient(ingredients, stack.func_82833_r());
                continue;
            }
            if (obj instanceof String) {
                String ore = (String)obj;
                this.pedestals.add(OreDictionary.getOres((String)ore));
                this.putIngredient(ingredients, ore + " (oredict)");
                continue;
            }
            if (obj instanceof List) {
                this.pedestals.add(obj);
                continue;
            }
            String ret = "Invalid combination crafting recipe: ";
            for (Object tmp : pedestals) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        this.inputList.add(Utils.localize((String)"tooltip.ec.items_required"));
        ingredients.forEach((s, i) -> this.inputList.add(" " + i + "x " + s));
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCost() {
        return this.cost;
    }

    public int getPerTick() {
        return this.perTick;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ArrayList<Object> getPedestalItems() {
        return this.pedestals;
    }

    public ArrayList<String> getInputList() {
        return this.inputList;
    }

    private void putIngredient(Map<String, Integer> ingredients, String name) {
        if (ingredients.containsKey(name)) {
            int current = ingredients.get(name);
            ingredients.replace(name, current + 1);
        } else {
            ingredients.put(name, 1);
        }
    }
}

