/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.recipes.ISonarRecipeItem;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeItemStack;
import sonar.core.recipes.RecipeObjectType;

public class RecipeOreStack
implements ISonarRecipeObject,
ISonarRecipeItem {
    public String oreType;
    public List<ItemStack> cachedRegister;
    public int stackSize;

    public RecipeOreStack(String oreType, int stackSize) {
        this.oreType = oreType;
        this.stackSize = stackSize;
    }

    @Override
    public Object getValue() {
        return this.getJEIValue();
    }

    @Override
    public boolean isNull() {
        return this.getJEIValue().isEmpty();
    }

    @Override
    public ItemStack getOutputStack() {
        return this.getJEIValue().get(0).func_77946_l();
    }

    @Override
    public boolean matches(Object object, RecipeObjectType type) {
        if (object instanceof RecipeItemStack) {
            object = ((RecipeItemStack)object).stack;
        }
        if (object instanceof RecipeOreStack) {
            RecipeOreStack oreStack = (RecipeOreStack)object;
            return oreStack.oreType.equals(this.oreType) && oreStack.stackSize >= this.stackSize;
        }
        if (object instanceof String) {
            return this.oreType.equals(object);
        }
        if (object instanceof ItemStack && type.checkStackSize(this.stackSize, ((ItemStack)object).func_190916_E())) {
            int oreID = OreDictionary.getOreID((String)this.oreType);
            for (int id : OreDictionary.getOreIDs((ItemStack)((ItemStack)object))) {
                if (oreID != id) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> getJEIValue() {
        if (this.cachedRegister == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack ore : OreDictionary.getOres((String)this.oreType)) {
                ItemStack newStack = ore.func_77946_l();
                newStack.func_190920_e(this.stackSize);
                stacks.add(newStack);
            }
            this.cachedRegister = stacks;
        }
        return this.cachedRegister;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }
}

