/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.animations;

import com.teamwizardry.librarianlib.features.animator.AnimatableProperty;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.IAnimatable;
import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import com.teamwizardry.librarianlib.features.animator.animations.Keyframe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0011\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/animations/KeyframeAnimation;", "T", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "target", "property", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/AnimatableProperty;)V", "Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "(Ljava/lang/Object;Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;)V", "_keyframes", "", "Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "[Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "value", "keyframes", "getKeyframes", "()[Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;", "setKeyframes", "([Lcom/teamwizardry/librarianlib/features/animator/animations/Keyframe;)V", "lerper", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "update", "", "time", "", "librarianlib-1.12.2"})
public final class KeyframeAnimation<T>
extends Animation<T> {
    private Keyframe[] _keyframes;
    private Lerper<Object> lerper;

    @NotNull
    public final Keyframe[] getKeyframes() {
        Keyframe[] keyframeArray = this._keyframes;
        Keyframe[] keyframeArray2 = Arrays.copyOf(keyframeArray, keyframeArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)keyframeArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return keyframeArray2;
    }

    public final void setKeyframes(@NotNull Keyframe[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.isInAnimator()) {
            throw (Throwable)new IllegalStateException("Cannot set keyframes after the animation has been added to an animator");
        }
        Keyframe[] keyframeArray = value;
        KeyframeAnimation keyframeAnimation = this;
        Keyframe[] keyframeArray2 = Arrays.copyOf(keyframeArray, keyframeArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)keyframeArray2, (String)"java.util.Arrays.copyOf(this, size)");
        Keyframe[] keyframeArray3 = keyframeArray2;
        keyframeAnimation._keyframes = keyframeArray3;
        Object[] $receiver$iv = this._keyframes;
        if ($receiver$iv.length > 1) {
            Object[] objectArray = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Keyframe it = (Keyframe)a;
                    Comparable comparable = Float.valueOf(it.getTime());
                    it = (Keyframe)b;
                    Comparable comparable2 = comparable;
                    Float f = Float.valueOf(it.getTime());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                }
            };
            ArraysKt.sortWith((Object[])objectArray, (Comparator)comparator);
        }
    }

    @Override
    public void update(float time) {
        Object $receiver$iv;
        Object $receiver$iv2;
        float progress2 = this.timeFraction(time);
        try {
            Object element$iv;
            block14: {
                $receiver$iv2 = this._keyframes;
                Iterator iterator2 = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv2))).iterator();
                while (iterator2.hasNext()) {
                    int index$iv = ((Number)iterator2.next()).intValue();
                    element$iv = $receiver$iv2[index$iv];
                    Object it = element$iv;
                    if (!(((Keyframe)it).getTime() <= progress2)) continue;
                    break block14;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $receiver$iv2 = element$iv;
        }
        catch (NoSuchElementException e) {
            $receiver$iv2 = null;
        }
        Object[] prev = $receiver$iv2;
        try {
            Keyframe element$iv2;
            block15: {
                for (Keyframe element$iv2 : $receiver$iv = this._keyframes) {
                    Keyframe it = element$iv2;
                    if (!(it.getTime() >= progress2)) {
                        continue;
                    }
                    break block15;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $receiver$iv = element$iv2;
        }
        catch (NoSuchElementException e) {
            $receiver$iv = null;
        }
        Keyframe[] next = $receiver$iv;
        if (prev != null && next != null) {
            if (next.getTime() == prev.getTime()) {
                this.getProperty().set(this.getTarget(), next.getValue());
            } else {
                float partialProgress = next.getEasing().invoke((progress2 - prev.getTime()) / (next.getTime() - prev.getTime()));
                this.getProperty().set(this.getTarget(), this.lerper.lerp(prev.getValue(), next.getValue(), partialProgress));
            }
        } else if (next != null) {
            this.getProperty().set(this.getTarget(), next.getValue());
        } else if (prev != null) {
            this.getProperty().set(this.getTarget(), prev.getValue());
        }
    }

    public KeyframeAnimation(@NotNull T target, @NotNull IAnimatable<T> property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        super(target, property);
        this._keyframes = new Keyframe[0];
        this.lerper = LerperHandler.INSTANCE.getLerperOrError(property.getType());
    }

    public KeyframeAnimation(@NotNull T target, @NotNull String property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this(target, AnimatableProperty.Companion.get(target.getClass(), property));
    }

    @PublishedApi
    public KeyframeAnimation(@NotNull T target, @NotNull AnimatableProperty<T> property) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this(target, (IAnimatable)property);
    }
}

