/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics;

import com.teamwizardry.librarianlib.features.autoregister.SerializerRegister;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializerRegister(classes={FluidStack.class})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\"\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/basics/SerializeFluidStack;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "Lnet/minecraftforge/fluids/FluidStack;", "()V", "getDefault", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "existing", "syncing", "", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "writeBytes", "", "value", "writeNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "librarianlib-1.12.2"})
public final class SerializeFluidStack
extends Serializer<FluidStack> {
    public static final SerializeFluidStack INSTANCE;

    @Override
    @NotNull
    protected FluidStack readNBT(@NotNull NBTBase nbt, @Nullable FluidStack existing, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBTHelper.castOrDefault(nbt, NBTTagCompound.class));
        if (fluidStack == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidStack.loadFluidStac\u2026gCompound::class.java))!!");
        return fluidStack;
    }

    @NotNull
    protected NBTTagCompound writeNBT(@NotNull FluidStack value, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        NBTTagCompound nBTTagCompound = value.writeToNBT(new NBTTagCompound());
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        return nBTTagCompound;
    }

    @Override
    @NotNull
    protected FluidStack readBytes(@NotNull ByteBuf buf, @Nullable FluidStack existing, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        FluidStack fluidStack = CommonUtilMethods.readFluidStack(buf);
        if (fluidStack == null) {
            fluidStack = new FluidStack(FluidRegistry.WATER, 0);
        }
        return fluidStack;
    }

    @Override
    protected void writeBytes(@NotNull ByteBuf buf, @NotNull FluidStack value, boolean syncing) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CommonUtilMethods.writeFluidStack(buf, value);
    }

    @Override
    @NotNull
    public FluidStack getDefault() {
        return new FluidStack(FluidRegistry.WATER, 0);
    }

    private SerializeFluidStack() {
        super(FieldType.Companion.create(FluidStack.class));
    }

    static {
        SerializeFluidStack serializeFluidStack;
        INSTANCE = serializeFluidStack = new SerializeFluidStack();
    }
}

