/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.config;

import com.bartz24.skyresources.alchemy.item.ItemOreAlchDust;
import com.bartz24.skyresources.base.MachineVariants;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="skyresources")
public class ConfigOptions {
    @Config.Comment(value={"Config Settings for the machines and casings"})
    public static ModularMachineSettings modularMachineSettings = new ModularMachineSettings();
    @Config.Comment(value={"Config Settings for Tools and Items"})
    public static ToolSettings toolSettings = new ToolSettings();
    @Config.Comment(value={"Config Settings for Machines"})
    public static MachineSettings machineSettings = new MachineSettings();
    @Config.Comment(value={"Config Settings for the Guide"})
    public static GuideSettings guideSettings = new GuideSettings();
    @Config.Comment(value={"Misc Config Settings"})
    public static MiscSettings miscSettings = new MiscSettings();
    @Config.Comment(value={"Config Settings for plugins"})
    public static PluginSettings pluginSettings = new PluginSettings();
    @Config.Comment(value={"Config Settings for the Alchemical Ore Rarity values. Higher numbers are rarer."})
    public static Map<String, Integer> alchemicalOreRarities = ItemOreAlchDust.defaultOreRarities();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("skyresources")) {
            ConfigManager.sync((String)"skyresources", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class PluginSettings {
        @Config.Comment(value={"Config Settings for Actually Additions"})
        public ActuallyAdditionsSettings actuallyAdditionsSettings = new ActuallyAdditionsSettings();
        @Config.Comment(value={"Config Settings for Applied Energistics"})
        public AppliedEnergisticsSettings appliedEnergisticsSettings = new AppliedEnergisticsSettings();
        @Config.Comment(value={"Config Settings for Armor Plus"})
        public ArmorPlusSettings armorPlusSettings = new ArmorPlusSettings();
        @Config.Comment(value={"Config Settings for Embers"})
        public EmbersSettings embersSettings = new EmbersSettings();
        @Config.Comment(value={"Config Settings for Forestry"})
        public ForestrySettings forestrySettings = new ForestrySettings();
        @Config.Comment(value={"Config Settings for Integrated Dynamics"})
        public IntegratedDynamicsSettings integratedDynamicsSettings = new IntegratedDynamicsSettings();
        @Config.Comment(value={"Config Settings for Tinkers Construct"})
        public TinkersConstructSettings tinkersConstructSettings = new TinkersConstructSettings();
        @Config.Comment(value={"Config Settings for Tech Reborn"})
        public TechRebornSettings techRebornSettings = new TechRebornSettings();
        @Config.Comment(value={"Config Settings for Thermal Expansion"})
        public ThermalExpansionSettings thermalExpansionSettings = new ThermalExpansionSettings();
        @Config.Comment(value={"Config Settings for Industrial Craft 2"})
        public IndustrialCraftSettings industrialCraftSettings = new IndustrialCraftSettings();
        @Config.Comment(value={"Config Settings for Rock Candy"})
        public RockCandySettings rockCandySettings = new RockCandySettings();
        @Config.Comment(value={"Config Settings for Void Island Control"})
        public VoidIslandControlSettings voidIslandControlSettings = new VoidIslandControlSettings();

        public class VoidIslandControlSettings {
            @Config.Comment(value={"Disable the Void Island Control plugin from loading"})
            public boolean disableVoidIslandControlPlugin = false;
            @Config.Comment(value={"Enable the special Void Island Control magma island"})
            public boolean enableMagmaIsland = true;
        }

        public class RockCandySettings {
            @Config.Comment(value={"Disable the Rock Candy plugin from loading"})
            public boolean disableRockCandyPlugin = false;
            @Config.Comment(value={"Add rock candy combustion recipe"})
            public boolean addRockCandyRecipe = true;
        }

        public class IndustrialCraftSettings {
            @Config.Comment(value={"Disable the Industrial Craft plugin from loading"})
            public boolean disableIndustrialCraftPlugin = false;
            @Config.Comment(value={"Add rubber life infusion and combustion recipes"})
            public boolean addRubberRecipes = true;
        }

        public class ThermalExpansionSettings {
            @Config.Comment(value={"Disable the Thermal Expansion plugin from loading"})
            public boolean disableThermalExpansionPlugin = false;
            @Config.Comment(value={"Add crystal fluid and lava recipes to magma crucible"})
            public boolean addSpecialMagmaCrucibleRecipes = true;
            @Config.Comment(value={"Add pyrotheum as heat source"})
            public boolean addPyrotheumHeatSource = true;
        }

        public class TechRebornSettings {
            @Config.Comment(value={"Disable the Tech Reborn plugin from loading"})
            public boolean disableTechRebornPlugin = false;
            @Config.Comment(value={"Add rubber life infusion and combustion recipes"})
            public boolean addRubberRecipes = true;
        }

        public class TinkersConstructSettings {
            @Config.Comment(value={"Disable the Tinkers Construct plugin from loading"})
            public boolean disableTinkersConstructPlugin = false;
            @Config.Comment(value={"Add slime ball/sapling life infusion and combustion recipes"})
            public boolean addSlimeRecipes = true;
        }

        public class IntegratedDynamicsSettings {
            @Config.Comment(value={"Disable the Integrated Dynamics plugin from loading"})
            public boolean disableIntegratedDynamicsPlugin = false;
            @Config.Comment(value={"Add menril berry/sapling life infusion recipes"})
            public boolean addMenrilRecipes = true;
        }

        public class ForestrySettings {
            @Config.Comment(value={"Disable the Forestry plugin from loading"})
            public boolean disableForestryPlugin = false;
            @Config.Comment(value={"Bee Attractor Time per cycle"})
            public int beeAttractorTime = 200;
            @Config.Comment(value={"Bee Attractor RF Rate"})
            public int beeAttractorPowerUsage = 100;
            @Config.Comment(value={"Bee Attractor Seed Oil Usage Rate"})
            public int beeAttractorSeedOilUsage = 20;
            @Config.Comment(value={"Bee Attractor Seed Oil Capacity"})
            public int beeAttractorSeedOilCapacity = 4000;
        }

        public class EmbersSettings {
            @Config.Comment(value={"Disable the Embers plugin from loading"})
            public boolean disableEmbersPlugin = false;
            @Config.Comment(value={"Add ember shard combustion recipe"})
            public boolean addEmberShardRecipe = true;
        }

        public class ArmorPlusSettings {
            @Config.Comment(value={"Disable the Armor Plus plugin from loading"})
            public boolean disableArmorPlusPlugin = false;
            @Config.Comment(value={"Add lava crystal combustion recipe"})
            public boolean addLavaCrystalRecipe = true;
        }

        public class AppliedEnergisticsSettings {
            @Config.Comment(value={"Disable the Applied Energistics plugin from loading"})
            public boolean disableAppliedEnergisticsPlugin = false;
            @Config.Comment(value={"Add inscriber press combustion recipes"})
            public boolean addPressRecipes = true;
        }

        public class ActuallyAdditionsSettings {
            @Config.Comment(value={"Disable the Actually Additions plugin from loading"})
            public boolean disableActuallyAdditionsPlugin = false;
            @Config.Comment(value={"Add canola to grass drops"})
            public boolean addCanolaDrop = true;
            @Config.Comment(value={"Add coffee to grass drops"})
            public boolean addCoffeeDrop = true;
            @Config.Comment(value={"Add flax to grass drops"})
            public boolean addFlaxDrop = true;
            @Config.Comment(value={"Add rice to grass drops"})
            public boolean addRiceDrop = true;
        }
    }

    public static class MiscSettings {
        @Config.Comment(value={"Heavy Snowball Damage Dealt"})
        public int heavySnowballDamage = 8;
        @Config.Comment(value={"Explosive Heavy Snowball Damage Dealt"})
        public int explosiveHeavySnowballDamage = 12;
        @Config.Comment(value={"Forces all gem types to be enabled"})
        public boolean allowAllGemTypes = false;
        @Config.Comment(value={"Add beetroot seeds to grass drops"})
        public boolean addBeetrootSeedDrop = true;
        @Config.Comment(value={"Add melon seeds to grass drops"})
        public boolean addMelonSeedDrop = true;
        @Config.Comment(value={"Add pumpkin seeds to grass drops"})
        public boolean addPumpkinSeedDrop = true;
        @Config.Comment(value={"Add cocoa beans to grass drops"})
        public boolean addCocoaBeanDrop = true;
        @Config.Comment(value={"Add carrots to grass drops"})
        public boolean addCarrotDrop = true;
        @Config.Comment(value={"Add potatoes to grass drops"})
        public boolean addPotatoDrop = true;
        @Config.Comment(value={"Mod priorities for materials like ingots and dusts"})
        public String[] modResourcePriorities = new String[]{"minecraft", "thermalfoundation", "immersiveengineering", "mekanism", "tconstruct", "ic2", "techreborn", "forestry", "embers"};
    }

    public static class GuideSettings {
        @Config.Comment(value={"Display info about Guide in a notification"})
        public boolean displayGuideMessage;
        @Config.Comment(value={"Enable the in-game Guide"})
        public boolean allowGuide = true;
        @Config.Comment(value={"Remember page open in Guide"})
        public boolean rememberGuide = true;
    }

    public static class MachineSettings {
        @Config.Comment(value={"Max amount in Fluid Dropper"})
        public int fluidDropperCapacity = 1000;
        @Config.Comment(value={"Dirt Furnace Fuel Rate"})
        public int dirtFurnaceFuelRate = 3;
        @Config.Comment(value={"Dirt Furnace Speed"})
        public int dirtFurnaceSpeed = 4;
        @Config.Comment(value={"Mini Freezer Speed"})
        public double miniFreezerSpeed = 0.25;
        @Config.Comment(value={"Iron Freezer Speed"})
        public double ironFreezerSpeed = 1.0;
        @Config.Comment(value={"Light Freezer Speed"})
        public double lightFreezerSpeed = 100.0;
        @Config.Comment(value={"Aqueous Concentrator Speed"})
        public int aqueousConcentratorSpeed = 5;
        @Config.Comment(value={"Aqueous Concentrator RF Rate"})
        public int aqueousConcentratorPowerUsage = 80;
        @Config.Comment(value={"Aqueous Deconcentrator Speed"})
        public int aqueousDeconcentratorSpeed = 10;
        @Config.Comment(value={"Aqueous Deconcentrator RF Rate"})
        public int aqueousDeconcentratorPowerUsage = 80;
        @Config.Comment(value={"Dark Matter Warper Fuel Time"})
        public int darkMatterWarperFuelTime = 3600;
        @Config.Comment(value={"Dark Matter Warper Effect Players"})
        public boolean darkMatterWarperEffectPlayers = true;
        @Config.Comment(value={"Dark Matter Warper Effect With no Fuel"})
        public boolean darkMatterWarperEffectNoFuel = true;
        @Config.Comment(value={"End Portal Difficulty Level Normal(Armed Silverfish), Easy(Unarmed Silverfish), Wuss(No Silverfish)"})
        public EndPortalDifficultyLevel endPortalMode = EndPortalDifficultyLevel.NORMAL;
        @Config.Comment(value={"Rock Cleaner Speed"})
        public int rockCleanerSpeed = 5;
        @Config.Comment(value={"Rock Cleaner RF Rate"})
        public int rockCleanerPowerUsage = 80;
        @Config.Comment(value={"Rock Crusher Speed"})
        public int rockCrusherSpeed = 2;
        @Config.Comment(value={"Rock Crusher RF Rate"})
        public int rockCrusherPowerUsage = 100;
        @Config.Comment(value={"Base Crucible Speed"})
        public int crucibleSpeed = 8;
        @Config.Comment(value={"Max amount in Crucible"})
        public int crucibleCapacity = 4000;
        @Config.Comment(value={"Base Fusion Speed"})
        public int fusionSpeed = 8;
        @Config.Comment(value={"Smart Combustion Controller Craft Time Rate (Ticks)"})
        public int combustionControllerTicks = 20;
        @Config.Comment(value={"Wildlife Attractor RF Rate"})
        public int wildlifeAttractorPowerUsage = 40;
        @Config.Comment(value={"Wildlife Attractor Water Usage Rate"})
        public int wildlifeAttractorWaterUsage = 20;
        @Config.Comment(value={"Wildlife Attractor Plant Matter Usage Time"})
        public int wildlifeAttractorMatterTime = 320;
        @Config.Comment(value={"Wildlife Attractor Water Capacity"})
        public int wildlifeAttractorWaterCapacity = 4000;
        @Config.Comment(value={"Wildlife Attractor Animal Ids"})
        public String[] wildlifeAttractorAnimalIDs = new String[]{"minecraft:sheep", "minecraft:cow", "minecraft:chicken", "minecraft:pig", "minecraft:rabbit", "minecraft:squid", "minecraft:horse", "minecraft:parrot"};

        public static enum EndPortalDifficultyLevel {
            NORMAL,
            EASY,
            WUSS;

        }
    }

    public static class ToolSettings {
        @Config.Comment(value={"Multiplier of knife's material damage"})
        public double knifeBaseDamage = 1.5;
        @Config.Comment(value={"Multiplier of knife's material durability"})
        public double knifeBaseDurability = 0.7f;
        @Config.Comment(value={"Multiplier of rock grinder's material damage"})
        public double rockGrinderBaseDamage = 2.5;
        @Config.Comment(value={"Multiplier of rock grinder's material durability"})
        public double rockGrinderBaseDurability = 0.8f;
        @Config.Comment(value={"Max amount in Water Extractor"})
        public int waterExtractorCapacity = 4000;
        @Config.Comment(value={"Max Health a Health Gem can store"})
        public int healthGemMaxHealth = 100;
        @Config.Comment(value={"Percent of health in Health Gem to add to player's health"})
        public double healthGemPercentage = 0.02f;
        @Config.Comment(value={"Multiplier of infusion stone's material durability"})
        public double infusionStoneBaseDurability = 1.0;
        @Config.Comment(value={"Allow infusion stones to bonemeal"})
        public boolean infusionStoneBonemealCapability = true;
        @Config.Comment(value={"Allow plant matter to bonemeal"})
        public boolean plantMatterBonemealCapability = true;
    }

    public static class ModularMachineSettings {
        @Config.Comment(value={"Set Machine Speeds"})
        public Map<String, Double> machineSpeed = this.defaultMachineSpeeds();
        @Config.Comment(value={"Set Machine Efficiencies"})
        public Map<String, Double> machineEfficiency = this.defaultMachineEfficiencies();
        @Config.Comment(value={"Set Machine Max HU"})
        public Map<String, Integer> machineMaxHU = this.defaultMachineMaxHUs();

        private Map<String, Double> defaultMachineSpeeds() {
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (MachineVariants v : MachineVariants.values()) {
                map.put(v.func_176610_l(), Double.valueOf(v.getDefaultRawSpeed()));
            }
            return map;
        }

        private Map<String, Double> defaultMachineEfficiencies() {
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (MachineVariants v : MachineVariants.values()) {
                map.put(v.func_176610_l(), Double.valueOf(v.getDefaultRawEfficiency()));
            }
            return map;
        }

        private Map<String, Integer> defaultMachineMaxHUs() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (MachineVariants v : MachineVariants.values()) {
                map.put(v.func_176610_l(), v.getDefaultMaxHeat());
            }
            return map;
        }
    }
}

