/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.plugin;

import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.plugin.IModPlugin;
import com.bartz24.skyresources.plugin.actuallyadditions.ActAddPlugin;
import com.bartz24.skyresources.plugin.ae2.AE2Plugin;
import com.bartz24.skyresources.plugin.armorplus.ArmorPlusPlugin;
import com.bartz24.skyresources.plugin.ctweaker.CraftTweakerPlugin;
import com.bartz24.skyresources.plugin.dracevo.DEPlugin;
import com.bartz24.skyresources.plugin.embers.EmbersPlugin;
import com.bartz24.skyresources.plugin.extrabees.ExtraBeesPlugin;
import com.bartz24.skyresources.plugin.extremereactors.ExtremeReactorsPlugin;
import com.bartz24.skyresources.plugin.forestry.ForestryPlugin;
import com.bartz24.skyresources.plugin.ic2.IC2Plugin;
import com.bartz24.skyresources.plugin.integdyn.IntegratedDynamicsPlugin;
import com.bartz24.skyresources.plugin.rockcandy.RockCandyPlugin;
import com.bartz24.skyresources.plugin.tconstruct.TConPlugin;
import com.bartz24.skyresources.plugin.techreborn.TechRebornPlugin;
import com.bartz24.skyresources.plugin.theoneprobe.TOPPlugin;
import com.bartz24.skyresources.plugin.thermal.ThermalPlugin;
import com.bartz24.skyresources.plugin.vic.VICPlugin;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;

public class ModPlugins {
    public static Map<String, IModPlugin> plugins = new HashMap<String, IModPlugin>();

    public static void preInit() {
        ModPlugins.addPlugin("actuallyadditions", ActAddPlugin.class, ConfigOptions.pluginSettings.actuallyAdditionsSettings.disableActuallyAdditionsPlugin);
        ModPlugins.addPlugin("appliedenergistics2", AE2Plugin.class, ConfigOptions.pluginSettings.appliedEnergisticsSettings.disableAppliedEnergisticsPlugin);
        ModPlugins.addPlugin("armorplus", ArmorPlusPlugin.class, ConfigOptions.pluginSettings.armorPlusSettings.disableArmorPlusPlugin);
        ModPlugins.addPlugin("crafttweaker", CraftTweakerPlugin.class, false);
        ModPlugins.addPlugin("draconicevolution", DEPlugin.class, false);
        ModPlugins.addPlugin("embers", EmbersPlugin.class, ConfigOptions.pluginSettings.embersSettings.disableEmbersPlugin);
        ModPlugins.addPlugin("extrabees", ExtraBeesPlugin.class, ConfigOptions.pluginSettings.forestrySettings.disableForestryPlugin);
        ModPlugins.addPlugin("bigreactors", ExtremeReactorsPlugin.class, false);
        ModPlugins.addPlugin("forestry", ForestryPlugin.class, ConfigOptions.pluginSettings.forestrySettings.disableForestryPlugin);
        ModPlugins.addPlugin("ic2", IC2Plugin.class, ConfigOptions.pluginSettings.industrialCraftSettings.disableIndustrialCraftPlugin);
        ModPlugins.addPlugin("integrateddynamics", IntegratedDynamicsPlugin.class, ConfigOptions.pluginSettings.integratedDynamicsSettings.disableIntegratedDynamicsPlugin);
        ModPlugins.addPlugin("rockcandy", RockCandyPlugin.class, ConfigOptions.pluginSettings.rockCandySettings.disableRockCandyPlugin);
        ModPlugins.addPlugin("techreborn", TechRebornPlugin.class, ConfigOptions.pluginSettings.techRebornSettings.disableTechRebornPlugin);
        ModPlugins.addPlugin("tconstruct", TConPlugin.class, ConfigOptions.pluginSettings.tinkersConstructSettings.disableTinkersConstructPlugin);
        ModPlugins.addPlugin("theoneprobe", TOPPlugin.class, false);
        ModPlugins.addPlugin("thermalfoundation", ThermalPlugin.class, ConfigOptions.pluginSettings.thermalExpansionSettings.disableThermalExpansionPlugin);
        ModPlugins.addPlugin("voidislandcontrol", VICPlugin.class, ConfigOptions.pluginSettings.voidIslandControlSettings.disableVoidIslandControlPlugin);
        for (IModPlugin p : plugins.values()) {
            p.preInit();
        }
    }

    public static void init() {
        for (IModPlugin p : plugins.values()) {
            p.init();
        }
    }

    public static void postInit() {
        for (IModPlugin p : plugins.values()) {
            p.postInit();
        }
    }

    public static void initRenderers() {
        for (IModPlugin p : plugins.values()) {
            p.initRenderers();
        }
    }

    public static void addPlugin(String modID, Class plugin, boolean disabled) {
        if (Loader.isModLoaded((String)modID) && !disabled) {
            try {
                plugins.put(modID, (IModPlugin)plugin.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

