/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.plugin.ctweaker;

import com.bartz24.skyresources.alchemy.FusionCatalysts;
import com.bartz24.skyresources.plugin.ctweaker.CraftTweakerPlugin;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.skyresources.catalysts")
public class MTCatalysts {
    @ZenMethod
    public static void add(IItemStack stack, float value) {
        MTCatalysts.addRecipe(CraftTweakerPlugin.toStack(stack), value);
    }

    @ZenMethod
    public static void remove(IItemStack stack) {
        MTCatalysts.removeRecipe(CraftTweakerPlugin.toStack(stack));
    }

    public static void addRecipe(ItemStack stack, float val) {
        CraftTweakerAPI.apply((IAction)new AddCatalyst(stack, val));
    }

    public static void removeRecipe(ItemStack stack) {
        CraftTweakerAPI.apply((IAction)new RemoveCatalyst(stack));
    }

    public static class RemoveCatalyst
    implements IAction {
        private final ItemStack stack;

        public RemoveCatalyst(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            FusionCatalysts.removeCTCatalyst(this.stack);
        }

        public String describe() {
            return "Removing catalyst value for " + this.stack.func_82833_r();
        }
    }

    private static class AddCatalyst
    implements IAction {
        private final ItemStack stack;
        private final float val;

        public AddCatalyst(ItemStack stack, float val) {
            this.stack = stack;
            this.val = val;
        }

        public void apply() {
            FusionCatalysts.addCTCatalyst(this.stack, this.val);
        }

        public String describe() {
            return "Adding catalyst value for " + this.stack.func_82833_r();
        }
    }
}

