/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.skyresources.technology.tile;

import com.bartz24.skyresources.base.tile.TileItemInventory;
import com.bartz24.skyresources.config.ConfigOptions;
import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MiniFreezerTile
extends TileItemInventory
implements ITickable {
    float[] timeFreeze;

    public MiniFreezerTile() {
        super("freezer", 2, new int[]{1}, new int[]{0});
    }

    public MiniFreezerTile(int slots, int[] noInsert, int[] noExtract) {
        super("freezer", slots, noInsert, noExtract);
    }

    public float getFreezerSpeed() {
        return (float)ConfigOptions.machineSettings.miniFreezerSpeed;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.timeFreeze != null) {
            for (int i = 0; i < this.timeFreeze.length; ++i) {
                compound.func_74776_a("time" + i, this.timeFreeze[i]);
            }
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.timeFreeze = new float[this.getInventory().getSlots()];
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            this.timeFreeze[i] = compound.func_74760_g("time" + i);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.timeFreeze == null) {
                this.timeFreeze = new float[this.getInventory().getSlots()];
                return;
            }
            this.updateMulti2x1();
            if (!this.hasValidMulti()) {
                return;
            }
            for (int i = 0; i < this.getInventory().getSlots() / 2; ++i) {
                ProcessRecipe recipe = this.recipeToCraft(i);
                if (recipe != null && this.canProcess(recipe.getOutputs().get(0).func_77946_l(), i + this.getInventory().getSlots() / 2)) {
                    if (this.timeFreeze[i] >= (float)this.getTimeReq(recipe, this.getInventory().getStackInSlot(i))) {
                        int amtProcessed = 0;
                        for (int amt = 0; amt < this.getGroupsFreezing(recipe, this.getInventory().getStackInSlot(i)); ++amt) {
                            if (!this.ejectResultSlot(recipe.getOutputs().get(0).func_77946_l(), i)) continue;
                            ++amtProcessed;
                        }
                        this.getInventory().getStackInSlot(i).func_190918_g(((ItemStack)recipe.getInputs().get(0)).func_190916_E() * amtProcessed);
                        if (this.getInventory().getStackInSlot(i).func_190916_E() <= 0) {
                            this.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
                        }
                        this.timeFreeze[i] = 0.0f;
                        continue;
                    }
                    int n = i;
                    this.timeFreeze[n] = this.timeFreeze[n] + this.getFreezerSpeed() * 10.0f;
                    continue;
                }
                this.timeFreeze[i] = 0.0f;
            }
            this.func_70296_d();
        }
    }

    private boolean canProcess(ItemStack output, int slotOut) {
        if (this.getInventory().getStackInSlot(slotOut).func_190926_b()) {
            return true;
        }
        if (!this.getInventory().getStackInSlot(slotOut).func_77969_a(output)) {
            return false;
        }
        int result = this.getInventory().getStackInSlot(slotOut).func_190916_E() + output.func_190916_E();
        return result <= this.getInventory().getSlotLimit(slotOut) && result <= this.getInventory().getStackInSlot(slotOut).func_77976_d();
    }

    int getGroupsFreezing(ProcessRecipe recipe, ItemStack input) {
        return (int)Math.floor((float)input.func_190916_E() / (float)((ItemStack)recipe.getInputs().get(0)).func_190916_E());
    }

    public int getTimeReq(ProcessRecipe recipe, ItemStack input) {
        return (int)(recipe.getIntParameter() * (float)this.getGroupsFreezing(recipe, input));
    }

    boolean ejectResultSlot(ItemStack output, int inSlot) {
        if (this.canProcess(output, inSlot + this.getInventory().getSlots() / 2)) {
            this.getInventory().insertInternalItem(inSlot + this.getInventory().getSlots() / 2, output, false);
            return true;
        }
        return false;
    }

    void updateMulti2x1() {
    }

    public boolean hasValidMulti() {
        return true;
    }

    public ProcessRecipe recipeToCraft(int slot) {
        if (slot >= this.getInventory().getSlots()) {
            return null;
        }
        ProcessRecipe recipe = ProcessRecipeManager.freezerRecipes.getRecipe(this.getInventory().getStackInSlot(slot), 2.1474836E9f, false, false);
        return recipe;
    }

    public int getUpdateIdSize() {
        return this.getInventory().getSlots();
    }

    public int getUpdateData(int id) {
        if (this.timeFreeze == null) {
            return 0;
        }
        return (int)this.timeFreeze[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientUpdate(int id, int data) {
        if (this.timeFreeze != null) {
            this.timeFreeze[id] = data;
        }
    }
}

