/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.machine.ItemBlockMachine;
import cofh.thermalexpansion.block.machine.TileBrewer;
import cofh.thermalexpansion.block.machine.TileCentrifuge;
import cofh.thermalexpansion.block.machine.TileCharger;
import cofh.thermalexpansion.block.machine.TileCompactor;
import cofh.thermalexpansion.block.machine.TileCrafter;
import cofh.thermalexpansion.block.machine.TileCrucible;
import cofh.thermalexpansion.block.machine.TileEnchanter;
import cofh.thermalexpansion.block.machine.TileExtruder;
import cofh.thermalexpansion.block.machine.TileFurnace;
import cofh.thermalexpansion.block.machine.TileInsolator;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.block.machine.TilePrecipitator;
import cofh.thermalexpansion.block.machine.TilePulverizer;
import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.block.machine.TileSawmill;
import cofh.thermalexpansion.block.machine.TileSmelter;
import cofh.thermalexpansion.block.machine.TileTransposer;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalexpansion.render.BakeryMachine;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.ItemUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockMachine
extends BlockTEBase
implements IModelRegister,
IBakeryProvider,
IWorldBlockTextureProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static boolean enableClassicRecipes = false;
    public static boolean enableUpgradeKitCrafting = false;
    public static ItemStack machineFurnace;
    public static ItemStack machinePulverizer;
    public static ItemStack machineSawmill;
    public static ItemStack machineSmelter;
    public static ItemStack machineInsolator;
    public static ItemStack machineCompactor;
    public static ItemStack machineCrucible;
    public static ItemStack machineRefinery;
    public static ItemStack machineTransposer;
    public static ItemStack machineCharger;
    public static ItemStack machineCentrifuge;
    public static ItemStack machineCrafter;
    public static ItemStack machineBrewer;
    public static ItemStack machineEnchanter;
    public static ItemStack machinePrecipitator;
    public static ItemStack machineExtruder;
    public static ItemBlockMachine itemBlock;

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149663_c("machine");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.FURNACE)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_MACHINE});
        builder.add(new IUnlistedProperty[]{TEProps.BAKERY_WORLD});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            if (!enable[i]) continue;
            if (TEProps.creativeTabShowAllBlockLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), TEProps.creativeTabLevel));
            }
            if (!TEProps.creativeTabShowCreative) continue;
            items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile.thermalexpansion.machine." + Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].func_176610_l() + ".name";
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta >= Type.values().length) {
            return null;
        }
        switch (Type.values()[meta]) {
            case FURNACE: {
                return new TileFurnace();
            }
            case PULVERIZER: {
                return new TilePulverizer();
            }
            case SAWMILL: {
                return new TileSawmill();
            }
            case SMELTER: {
                return new TileSmelter();
            }
            case INSOLATOR: {
                return new TileInsolator();
            }
            case COMPACTOR: {
                return new TileCompactor();
            }
            case CRUCIBLE: {
                return new TileCrucible();
            }
            case REFINERY: {
                return new TileRefinery();
            }
            case TRANSPOSER: {
                return new TileTransposer();
            }
            case CHARGER: {
                return new TileCharger();
            }
            case CENTRIFUGE: {
                return new TileCentrifuge();
            }
            case CRAFTER: {
                return new TileCrafter();
            }
            case BREWER: {
                return new TileBrewer();
            }
            case ENCHANTER: {
                return new TileEnchanter();
            }
            case PRECIPITATOR: {
                return new TilePrecipitator();
            }
            case EXTRUDER: {
                return new TileExtruder();
            }
        }
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileMachineBase tile = (TileMachineBase)world.func_175625_s(pos);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.readAugmentsFromNBT(stack.func_77978_p());
            tile.updateAugmentStatus();
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing((ItemStack)stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache((ItemStack)stack, (byte[])tile.getDefaultSides());
            for (int i = 0; i < sideCache.length; ++i) {
                if (sideCache[i] < tile.getNumConfig(i)) continue;
                sideCache[i] = 0;
            }
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = 0;
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileMachineBase tile = (TileMachineBase)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ItemStack heldItem = player.func_184586_b(hand);
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (FluidHelper.isFluidHandler((ItemStack)heldItem)) {
                FluidHelper.interactWithHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryMachine.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        if (side == EnumFacing.DOWN) {
            return TETextures.MACHINE_BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TETextures.MACHINE_TOP;
        }
        return side != EnumFacing.NORTH ? TETextures.MACHINE_SIDE : TETextures.MACHINE_FACE[stack.func_77960_j() % Type.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileMachineBase) {
            TileMachineBase tile = (TileMachineBase)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileMachineBase tile = (TileMachineBase)((Object)((Object)state.getValue(TEProps.TILE_MACHINE)));
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            builder.append(",creative=").append(tile.isCreative);
            builder.append(",level=").append(tile.getLevel());
            builder.append(",facing=").append(tile.getFacing());
            builder.append(",active=").append(tile.isActive);
            builder.append(",side_config={");
            for (byte i : tile.sideCache) {
                builder.append(",").append(i);
            }
            builder.append("}");
            if (tile.hasFluidUnderlay() && tile.isActive) {
                FluidStack stack = tile.getRenderFluid();
                builder.append(",fluid=").append(stack != null ? Integer.valueOf(FluidHelper.getFluidHash((FluidStack)stack)) : tile.getTexture(tile.getFacing(), 0).func_94215_i());
            }
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean preInit() {
        this.setRegistryName("machine");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockMachine((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileMachineBase.config();
        TileFurnace.initialize();
        TilePulverizer.initialize();
        TileSawmill.initialize();
        TileSmelter.initialize();
        TileInsolator.initialize();
        TileCompactor.initialize();
        TileCrucible.initialize();
        TileRefinery.initialize();
        TileTransposer.initialize();
        TileCharger.initialize();
        TileCentrifuge.initialize();
        TileCrafter.initialize();
        TileBrewer.initialize();
        TileEnchanter.initialize();
        TilePrecipitator.initialize();
        TileExtruder.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        machineFurnace = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FURNACE.getMetadata()));
        machinePulverizer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.PULVERIZER.getMetadata()));
        machineSawmill = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.SAWMILL.getMetadata()));
        machineSmelter = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.SMELTER.getMetadata()));
        machineInsolator = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.INSOLATOR.getMetadata()));
        machineCompactor = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.COMPACTOR.getMetadata()));
        machineCrucible = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.CRUCIBLE.getMetadata()));
        machineRefinery = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.REFINERY.getMetadata()));
        machineTransposer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.TRANSPOSER.getMetadata()));
        machineCharger = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.CHARGER.getMetadata()));
        machineCentrifuge = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.CENTRIFUGE.getMetadata()));
        machineCrafter = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.CRAFTER.getMetadata()));
        machineBrewer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.BREWER.getMetadata()));
        machineEnchanter = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ENCHANTER.getMetadata()));
        machinePrecipitator = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.PRECIPITATOR.getMetadata()));
        machineExtruder = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.EXTRUDER.getMetadata()));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        String copperPart = "gearCopper";
        String constantanPart = "gearConstantan";
        if (enable[Type.FURNACE.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineFurnace, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), Blocks.field_150336_V});
        }
        if (enable[Type.PULVERIZER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machinePulverizer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), Items.field_151145_ak});
        }
        if (enable[Type.SAWMILL.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineSawmill, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), ItemMaterial.partSawBlade, Character.valueOf('Y'), "plankWood"});
        }
        if (enable[Type.SMELTER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineSmelter, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "gearInvar", Character.valueOf('Y'), "sand"});
        }
        if (enable[Type.INSOLATOR.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineInsolator, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "gearLumium", Character.valueOf('Y'), "dirt"});
        }
        if (enable[Type.COMPACTOR.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineCompactor, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "ingotBronze"});
        }
        if (enable[Type.CRUCIBLE.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineCrucible, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), Blocks.field_150385_bj});
        }
        if (enable[Type.REFINERY.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineRefinery, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), constantanPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "gearNickel", Character.valueOf('Y'), "blockGlass"});
        }
        if (enable[Type.TRANSPOSER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineTransposer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"});
        }
        if (enable[Type.CHARGER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineCharger, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "gearLead", Character.valueOf('Y'), ItemMaterial.powerCoilSilver});
        }
        if (enable[Type.CENTRIFUGE.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineCentrifuge, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Items.field_151111_aL, Character.valueOf('Y'), "ingotConstantan"});
        }
        if (enable[Type.CRAFTER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineCrafter, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "workbench", Character.valueOf('Y'), "ingotTin"});
        }
        if (enable[Type.BREWER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineBrewer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), constantanPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Items.field_151067_bt, Character.valueOf('Y'), "blockGlassHardened"});
        }
        if (enable[Type.ENCHANTER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineEnchanter, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), constantanPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Blocks.field_150381_bn, Character.valueOf('Y'), "blockLapis"});
        }
        if (enable[Type.PRECIPITATOR.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machinePrecipitator, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "ingotInvar"});
        }
        if (enable[Type.EXTRUDER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)machineExtruder, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameMachine, Character.valueOf('I'), copperPart, Character.valueOf('P'), ItemMaterial.powerCoilGold, Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "ingotInvar"});
        }
    }

    private void addUpgradeRecipes() {
        if (!enableUpgradeKitCrafting) {
            return;
        }
        for (int i = 0; i < Type.values().length; ++i) {
            int j;
            if (!enable[i]) continue;
            ItemStack[] block = new ItemStack[5];
            for (j = 0; j < 5; ++j) {
                block[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes) {
            return;
        }
        for (int i = 0; i < Type.values().length; ++i) {
            if (!enable[i]) continue;
            ItemStack[] machine = new ItemStack[5];
            for (int j = 0; j < 5; ++j) {
                machine[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[0], Character.valueOf('I'), "ingotInvar"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), machine[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[2], Character.valueOf('I'), "ingotSignalum"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[3], Character.valueOf('I'), "ingotEnderium"});
        }
    }

    public static enum Type implements IStringSerializable
    {
        FURNACE(0, "furnace"),
        PULVERIZER(1, "pulverizer"),
        SAWMILL(2, "sawmill"),
        SMELTER(3, "smelter"),
        INSOLATOR(4, "insolator"),
        COMPACTOR(5, "compactor"),
        CRUCIBLE(6, "crucible"),
        REFINERY(7, "refinery"),
        TRANSPOSER(8, "transposer"),
        CHARGER(9, "charger"),
        CENTRIFUGE(10, "centrifuge"),
        CRAFTER(11, "crafter"),
        BREWER(12, "brewer"),
        ENCHANTER(13, "enchanter"),
        PRECIPITATOR(14, "precipitator"),
        EXTRUDER(15, "extruder");

        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

