/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.texture;

import ic2.api.classic.event.RetextureEventClassic;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.block.base.util.texture.ICopyEntry;
import ic2.core.block.render.model.ModelTexturedWall;
import ic2.core.util.helpers.ToolHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TextureCopyEntry
implements INetworkFieldData,
ICopyEntry {
    final EnumFacing blockSide;
    RetextureEventClassic.Rotation[] rotations;
    int[] colorMultiplier;
    EnumFacing side;
    IBlockState modelState;
    IBlockState renderState;
    Block block;

    public TextureCopyEntry(EnumFacing facing) {
        this.blockSide = facing;
    }

    public void clear() {
        this.rotations = null;
        this.colorMultiplier = null;
        this.side = null;
        this.modelState = null;
        this.renderState = null;
        this.block = null;
    }

    public void set(IBlockState model, IBlockState render, int[] colors, RetextureEventClassic.Rotation[] texRotations, EnumFacing facing) {
        this.block = model.func_177230_c();
        this.modelState = model;
        this.renderState = render;
        this.colorMultiplier = colors;
        this.rotations = texRotations;
        this.side = facing;
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.block = null;
        this.side = null;
        this.modelState = null;
        this.renderState = null;
        this.colorMultiplier = null;
        this.rotations = null;
        byte state = buffer.readByte();
        if (state == 0) {
            return;
        }
        this.block = (Block)buffer.readForgeRegistryEntry(Block.field_149771_c);
        if (this.block == null) {
            return;
        }
        this.modelState = ToolHelper.stringToBlockState(this.block, buffer.readString());
        this.renderState = ToolHelper.stringToBlockState(this.block, buffer.readString());
        this.side = EnumFacing.func_82600_a((int)buffer.readByte());
        this.colorMultiplier = new int[buffer.readByte()];
        for (int i = 0; i < this.colorMultiplier.length; ++i) {
            this.colorMultiplier[i] = buffer.readInt();
        }
        this.rotations = RetextureEventClassic.Rotation.convert(buffer.readBytes());
        if (this.rotations.length != this.colorMultiplier.length) {
            this.rotations = Arrays.copyOf(this.rotations, this.colorMultiplier.length);
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        if (this.block == null) {
            buffer.writeByte((byte)0);
            return;
        }
        buffer.writeByte((byte)1);
        buffer.writeForgeEntry((IForgeRegistryEntry)this.block);
        buffer.writeString(ToolHelper.blockStateToString(this.modelState));
        buffer.writeString(ToolHelper.blockStateToString(this.renderState));
        buffer.writeByte((byte)this.side.func_176745_a());
        buffer.writeByte((byte)this.colorMultiplier.length);
        for (int i = 0; i < this.colorMultiplier.length; ++i) {
            buffer.writeInt(this.colorMultiplier[i]);
        }
        buffer.writeBytes(RetextureEventClassic.Rotation.invertConverting(this.rotations));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.block = null;
        this.side = null;
        this.modelState = null;
        this.renderState = null;
        this.colorMultiplier = null;
        if (!nbt.func_74767_n("Storage")) {
            return;
        }
        this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("BlockID")));
        this.modelState = ToolHelper.stringToBlockState(this.block, nbt.func_74779_i("ModelState"));
        this.renderState = ToolHelper.stringToBlockState(this.block, nbt.func_74779_i("RenderState"));
        this.side = EnumFacing.func_82600_a((int)nbt.func_74771_c("Side"));
        byte layers = nbt.func_74771_c("Layers");
        this.colorMultiplier = nbt.func_74759_k("Colors");
        if (this.colorMultiplier.length != layers) {
            this.colorMultiplier = Arrays.copyOf(this.colorMultiplier, (int)layers);
        }
        this.rotations = RetextureEventClassic.Rotation.convert(nbt.func_74770_j("Rotations"));
        if (this.rotations.length != layers) {
            this.rotations = Arrays.copyOf(this.rotations, (int)layers);
        }
    }

    public void writeFromNBT(NBTTagCompound nbt) {
        if (this.block == null) {
            nbt.func_74757_a("Storage", false);
            return;
        }
        ResourceLocation id = this.block.getRegistryName();
        if (id == null) {
            nbt.func_74757_a("Storage", false);
            return;
        }
        nbt.func_74757_a("Storage", true);
        nbt.func_74778_a("BlockID", id.toString());
        nbt.func_74778_a("ModelState", ToolHelper.blockStateToString(this.modelState));
        nbt.func_74778_a("RenderState", ToolHelper.blockStateToString(this.renderState));
        nbt.func_74774_a("Side", (byte)this.side.func_176745_a());
        nbt.func_74774_a("Layers", (byte)this.colorMultiplier.length);
        nbt.func_74783_a("Colors", this.colorMultiplier);
        nbt.func_74773_a("Rotations", RetextureEventClassic.Rotation.invertConverting(this.rotations));
    }

    public static TextureCopyEntry[] createArray(int amount) {
        TextureCopyEntry[] array = new TextureCopyEntry[amount];
        for (int i = 0; i < amount; ++i) {
            array[i] = new TextureCopyEntry(EnumFacing.func_82600_a((int)i));
        }
        return array;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int[] getColorMultiplier() {
        return this.colorMultiplier;
    }

    @Override
    public IBlockState getModelState() {
        return this.modelState;
    }

    @Override
    public IBlockState getRenderState() {
        return this.renderState;
    }

    @Override
    public EnumFacing getSide() {
        return this.side;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getQuads() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockModelShapes shapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        int i = 0;
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)this.modelState.func_177230_c().func_180664_k());
        IBakedModel model = shapes.func_178125_b(this.modelState);
        for (BakedQuad quad : model.func_188616_a(this.renderState, this.side, 0L)) {
            BakedQuad[][] quadData = ModelTexturedWall.getCache(quad.func_187508_a());
            int index = quad.func_178212_b() ? this.blockSide.func_176745_a() * 50 + i : -1;
            quads.add(ModelTexturedWall.copyWithIndex(quadData[this.blockSide.func_176745_a()][this.rotations[i].ordinal()], index));
            ++i;
        }
        ForgeHooksClient.setRenderLayer(null);
        return quads;
    }
}

