/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.util;

import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import funwayguy.skygrid.core.SkyGrid;
import funwayguy.skygrid.util.JsonHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;

public class CustomLootTableManager {
    private static List<LootMapping> LOOT_MAP = new ArrayList<LootMapping>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    public static boolean dad = false;
    public static String[] dadPre = new String[]{"Happy %s Appreciation %s!", "Happy Birthday %s!", "Happy %s Awareness %s!", "Happy %s Conservation %s!", "RISE UP LIGHTS!"};
    public static String[] dadName = new String[]{"Darksoto", "Darksoda", "Derposto", "Darktoasto", "Darkroasto", "DarkCostCo", "Cheatosto", "Saltyosto", "Rantosto", "Penguinosto"};
    public static String[] dadPost = new String[]{"Day", "Decade", "Hour", "Week", "Month"};

    public static void LoadLoot(File file, LootTableManager manager) {
        if (!file.exists()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            CustomLootTableManager.GenerateDefault(file);
        }
        JsonObject json = JsonHelper.ReadObjectFromFile(file);
        LOOT_MAP.clear();
        for (JsonElement e : JsonHelper.GetArray(json, "placement")) {
            if (e == null || !e.isJsonObject()) continue;
            LootMapping map = new LootMapping();
            map.readFromJson(e.getAsJsonObject());
            LOOT_MAP.add(map);
        }
        for (JsonElement e : JsonHelper.GetArray(json, "lootTables")) {
            if (e == null || !e.isJsonObject()) continue;
            CustomLootTable tbl = new CustomLootTable();
            tbl.readFromJson(e.getAsJsonObject());
            JsonArray fmtAry = new JsonArray();
            fmtAry.add((JsonElement)tbl.getFormatted());
            JsonObject fmtObj = new JsonObject();
            fmtObj.add("pools", (JsonElement)fmtAry);
            String fmt = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)fmtObj);
            try {
                ResourceLocation tableID = new ResourceLocation(tbl.name);
                LootTable vanTable = ForgeHooks.loadLootTable((Gson)GSON, (ResourceLocation)tableID, (String)fmt, (boolean)true, (LootTableManager)manager);
                LoadingCache registeredLootTables = (LoadingCache)ObfuscationReflectionHelper.getPrivateValue(LootTableManager.class, (Object)manager, (String[])new String[]{"field_186527_c", "registeredLootTables"});
                registeredLootTables.put((Object)tableID, (Object)vanTable);
            }
            catch (Exception ex) {
                SkyGrid.logger.log(Level.ERROR, "Unable to register custom loot table " + tbl.name, (Throwable)ex);
                continue;
            }
            SkyGrid.logger.log(Level.INFO, "Registered custom loot table " + tbl.name);
        }
    }

    private static void GenerateDefault(File file) {
        JsonObject parentJson = new JsonObject();
        JsonArray mappings = new JsonArray();
        JsonObject jMap = new JsonObject();
        LootMapping map = new LootMapping();
        map.tables.add(new ResourceLocation("skygrid:ingots"));
        map.tables.addAll(LootTableList.func_186374_a());
        map.writeToJson(jMap);
        mappings.add((JsonElement)jMap);
        parentJson.add("placement", (JsonElement)mappings);
        JsonArray tables = new JsonArray();
        CustomLootTable ltb = new CustomLootTable();
        ltb.name = "skygrid:ingots";
        ltb.maxItems = 3;
        CustomLootEntry len = new CustomLootEntry();
        len.id = "minecraft:diamond";
        len.maxStack = 8;
        len.weight = 1;
        ltb.entries.add(len);
        len = new CustomLootEntry();
        len.id = "minecraft:gold_ingot";
        len.maxStack = 8;
        len.weight = 2;
        ltb.entries.add(len);
        len = new CustomLootEntry();
        len.id = "minecraft:iron_ingot";
        len.maxStack = 8;
        len.weight = 3;
        ltb.entries.add(len);
        tables.add((JsonElement)ltb.writeToJson(new JsonObject()));
        parentJson.add("lootTables", (JsonElement)tables);
        JsonHelper.WriteToFile(file, (JsonElement)parentJson);
    }

    public static ResourceLocation getTable(World world, BlockPos pos, Random rand) {
        int dimension = world.field_73011_w.getDimension();
        Biome biome = world.func_180494_b(pos);
        ResourceLocation biomeReg = biome.getRegistryName();
        IBlockState state = world.func_180495_p(pos);
        ResourceLocation blockReg = state.func_177230_c().getRegistryName();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (LootMapping entry : LOOT_MAP) {
            if (!entry.isApplicable(dimension, biomeReg, blockReg)) continue;
            list.addAll(entry.tables);
        }
        if (list.size() <= 0) {
            return LootTableList.field_186419_a;
        }
        return (ResourceLocation)list.get(rand.nextInt(list.size()));
    }

    public static class CustomLootEntry {
        String id = "minecraft:diamond";
        int minStack = 1;
        int maxStack = 1;
        int meta = 0;
        int weight = 1;

        public void readFromJson(JsonObject json) {
            this.id = JsonHelper.GetString(json, "id", "minecraft:diamond");
            this.minStack = JsonHelper.GetNumber(json, "minStack", this.minStack).intValue();
            this.maxStack = JsonHelper.GetNumber(json, "maxStack", this.maxStack).intValue();
            this.meta = JsonHelper.GetNumber(json, "meta", 0).intValue();
            this.weight = JsonHelper.GetNumber(json, "weight", 1).intValue();
        }

        public JsonObject writeToJson(JsonObject json) {
            json.addProperty("id", this.id);
            json.addProperty("minStack", (Number)this.minStack);
            json.addProperty("maxStack", (Number)this.maxStack);
            json.addProperty("meta", (Number)this.meta);
            json.addProperty("weight", (Number)this.weight);
            return json;
        }

        public JsonObject getFormatted() {
            JsonObject func;
            JsonObject json = new JsonObject();
            json.addProperty("type", "item");
            json.addProperty("name", this.id);
            json.addProperty("weight", (Number)this.weight);
            JsonArray fList = new JsonArray();
            if (this.meta > 0) {
                func = new JsonObject();
                func.addProperty("function", "set_data");
                func.addProperty("data", (Number)this.meta);
                fList.add((JsonElement)func);
            }
            if (this.maxStack > 1) {
                func = new JsonObject();
                func.addProperty("function", "set_count");
                if (this.maxStack != this.minStack) {
                    JsonObject cnt = new JsonObject();
                    cnt.addProperty("min", (Number)this.minStack);
                    cnt.addProperty("max", (Number)this.maxStack);
                    func.add("count", (JsonElement)cnt);
                } else {
                    func.addProperty("count", (Number)this.maxStack);
                }
                fList.add((JsonElement)func);
            }
            json.add("functions", (JsonElement)fList);
            return json;
        }
    }

    public static class CustomLootTable {
        ArrayList<CustomLootEntry> entries = new ArrayList();
        String name = "generic";
        int minItems = 1;
        int maxItems = 100;

        public void readFromJson(JsonObject json) {
            this.name = JsonHelper.GetString(json, "name", "generic");
            this.minItems = JsonHelper.GetNumber(json, "minItems", 1).intValue();
            this.maxItems = JsonHelper.GetNumber(json, "maxItems", 100).intValue();
            this.entries.clear();
            for (JsonElement e : JsonHelper.GetArray(json, "entries")) {
                if (e == null || !e.isJsonObject()) continue;
                CustomLootEntry entry = new CustomLootEntry();
                entry.readFromJson(e.getAsJsonObject());
                this.entries.add(entry);
            }
        }

        public JsonObject writeToJson(JsonObject json) {
            json.addProperty("name", this.name);
            json.addProperty("minItems", (Number)this.minItems);
            json.addProperty("maxItems", (Number)this.maxItems);
            JsonArray eAry = new JsonArray();
            for (CustomLootEntry e : this.entries) {
                eAry.add((JsonElement)e.writeToJson(new JsonObject()));
            }
            json.add("entries", (JsonElement)eAry);
            return json;
        }

        public JsonObject getFormatted() {
            JsonObject json = new JsonObject();
            JsonObject rolls = new JsonObject();
            rolls.addProperty("min", (Number)this.minItems);
            rolls.addProperty("max", (Number)this.maxItems);
            json.add("rolls", (JsonElement)rolls);
            JsonArray eAry = new JsonArray();
            for (CustomLootEntry e : this.entries) {
                eAry.add((JsonElement)e.getFormatted());
            }
            json.add("entries", (JsonElement)eAry);
            return json;
        }
    }

    public static class LootMapping {
        List<Integer> dimensions = new ArrayList<Integer>();
        List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        List<ResourceLocation> blocks = new ArrayList<ResourceLocation>();
        List<ResourceLocation> tables = new ArrayList<ResourceLocation>();

        public boolean isApplicable(int dim, ResourceLocation biome, ResourceLocation block) {
            return !(this.dimensions.size() > 0 && !this.dimensions.contains(dim) || this.biomes.size() > 0 && (!this.biomes.contains(biome) || this.blocks.size() > 0 && !this.blocks.contains(block)));
        }

        public void readFromJson(JsonObject json) {
            this.biomes.clear();
            for (JsonElement element : JsonHelper.GetArray(json, "biomes")) {
                if (element == null || !element.isJsonPrimitive()) continue;
                this.biomes.add(new ResourceLocation(element.getAsString()));
            }
            this.dimensions.clear();
            for (JsonElement element : JsonHelper.GetArray(json, "dimensions")) {
                if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) continue;
                this.dimensions.add(element.getAsInt());
            }
            this.blocks.clear();
            for (JsonElement element : JsonHelper.GetArray(json, "blocks")) {
                ResourceLocation loc;
                if (element == null || !element.isJsonPrimitive() || (loc = new ResourceLocation(element.getAsString())) == null) continue;
                this.blocks.add(loc);
            }
            this.tables.clear();
            for (JsonElement element : JsonHelper.GetArray(json, "tables")) {
                if (element == null || !element.isJsonPrimitive()) continue;
                this.tables.add(new ResourceLocation(element.getAsString()));
            }
        }

        public JsonObject writeToJson(JsonObject json) {
            JsonArray blAry = new JsonArray();
            for (ResourceLocation resourceLocation : this.blocks) {
                blAry.add((JsonElement)new JsonPrimitive(resourceLocation.toString()));
            }
            json.add("blocks", (JsonElement)blAry);
            JsonArray bAry = new JsonArray();
            for (ResourceLocation resourceLocation : this.biomes) {
                bAry.add((JsonElement)new JsonPrimitive(resourceLocation.toString()));
            }
            json.add("biomes", (JsonElement)bAry);
            JsonArray jsonArray = new JsonArray();
            for (Integer i : this.dimensions) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)(i == null ? 0 : i)));
            }
            json.add("dimensions", (JsonElement)jsonArray);
            JsonArray jsonArray2 = new JsonArray();
            for (ResourceLocation loc : this.tables) {
                jsonArray2.add((JsonElement)new JsonPrimitive(loc.toString()));
            }
            json.add("tables", (JsonElement)jsonArray2);
            return json;
        }
    }
}

