/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.cropdusting.events;

import com.mramericanmike.cropdusting.configuration.ConfigValues;
import com.mramericanmike.cropdusting.init.ModItems;
import com.mramericanmike.cropdusting.init.ModSounds;
import com.mramericanmike.cropdusting.utils.Utilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerTickEvent {
    private int RADIUS = ConfigValues.effectRadius;
    private int TIMER = ConfigValues.updateTimer;
    private int FARTCHANCES = ConfigValues.fartEvery;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer thePlayer = event.player;
        World theWorld = thePlayer.field_70170_p;
        if (thePlayer != null && thePlayer instanceof EntityPlayer && event.phase == TickEvent.Phase.END && thePlayer.func_70093_af()) {
            NBTTagCompound playerData = event.player.getEntityData();
            NBTTagCompound data = PlayerTickEvent.getTagSafe(playerData, "PlayerPersisted");
            if (data.func_74762_e("cropdusting-timer") == 0) {
                data.func_74768_a("cropdusting-timer", this.TIMER);
                playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
                BlockPos thePosition = new BlockPos(thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v);
                boolean foundGrowable = false;
                for (int xAxis = -this.RADIUS; xAxis <= this.RADIUS; ++xAxis) {
                    for (int zAxis = -this.RADIUS; zAxis <= this.RADIUS; ++zAxis) {
                        for (int yAxis = -1; yAxis <= 1; ++yAxis) {
                            BlockPos actualPos = new BlockPos((Vec3i)thePosition.func_177982_a(xAxis, yAxis, zAxis));
                            Block checkBlock = theWorld.func_180495_p(actualPos).func_177230_c();
                            if (!Utilities.isGrowable(checkBlock)) continue;
                            foundGrowable = true;
                            Utilities.doUpdates(theWorld, actualPos);
                        }
                    }
                }
                if (foundGrowable) {
                    if (theWorld.field_72995_K) {
                        int yaw = (int)thePlayer.field_70177_z;
                        if (yaw < 0) {
                            yaw += 360;
                        }
                        yaw += 22;
                        int facing = (yaw %= 360) / 45;
                        double xOff = 0.0;
                        double zOff = 0.0;
                        switch (facing) {
                            case 0: {
                                zOff = -0.25;
                                break;
                            }
                            case 1: {
                                xOff = 0.25;
                                zOff = -0.25;
                                break;
                            }
                            case 2: {
                                xOff = 0.25;
                                break;
                            }
                            case 3: {
                                xOff = 0.25;
                                zOff = 0.25;
                                break;
                            }
                            case 4: {
                                zOff = 0.25;
                                break;
                            }
                            case 5: {
                                xOff = -0.25;
                                zOff = 0.25;
                                break;
                            }
                            case 6: {
                                xOff = -0.25;
                                break;
                            }
                            case 7: {
                                xOff = -0.25;
                                zOff = -0.25;
                            }
                        }
                        Random generator = new Random();
                        double number = generator.nextDouble() * 0.2 - 0.2;
                        zOff += number;
                        double number2 = generator.nextDouble() * 0.2 - 0.2;
                        double xOff2 = (xOff += number) + number2;
                        double zOff2 = xOff + number2;
                        if (Utilities.randInt(1, 5) == 1) {
                            theWorld.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, thePlayer.field_70165_t, thePlayer.field_70163_u + 0.5, thePlayer.field_70161_v, xOff, 0.1, zOff, new int[0]);
                        }
                        if (Utilities.randInt(1, 10) == 1) {
                            theWorld.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, thePlayer.field_70165_t, thePlayer.field_70163_u + 0.5, thePlayer.field_70161_v, xOff2, 0.1, zOff2, new int[0]);
                        }
                    }
                    if (!theWorld.field_72995_K) {
                        if (ConfigValues.enableFarts && Utilities.randInt(1, this.FARTCHANCES) == 1) {
                            PlayerTickEvent.doFart(theWorld, thePosition, thePlayer);
                            if (ConfigValues.enablePoop) {
                                ItemStack dropPoop = new ItemStack(ModItems.POOP, 1, 0);
                                EntityItem itemDrop = new EntityItem(theWorld, (double)thePosition.func_177958_n() + 0.5, (double)thePosition.func_177956_o() + 0.5, (double)thePosition.func_177952_p() + 0.5, dropPoop);
                                theWorld.func_72838_d((Entity)itemDrop);
                            }
                        }
                        if (ConfigValues.enablePoop && !ConfigValues.enableFarts && Utilities.randInt(1, this.FARTCHANCES) == 1) {
                            ItemStack dropPoop = new ItemStack(ModItems.POOP, 1, 0);
                            EntityItem itemDrop = new EntityItem(theWorld, (double)thePosition.func_177958_n() + 0.5, (double)thePosition.func_177956_o() + 0.5, (double)thePosition.func_177952_p() + 0.5, dropPoop);
                            theWorld.func_72838_d((Entity)itemDrop);
                        }
                    }
                    foundGrowable = false;
                }
            }
            if (data.func_74762_e("cropdusting-timer") != 0) {
                int actualTimer = data.func_74762_e("cropdusting-timer") - 1;
                data.func_74768_a("cropdusting-timer", actualTimer);
                playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
            }
        }
    }

    public static NBTTagCompound getTagSafe(NBTTagCompound tag, String key) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagCompound();
        }
        return tag.func_74775_l(key);
    }

    public static void doFart(World theWorld, BlockPos thePosition, EntityPlayer thePlayer) {
        SoundEvent theSound = ModSounds.FART_A;
        int fart = Utilities.randInt(0, 5);
        switch (fart) {
            case 0: {
                theSound = ModSounds.FART_A;
                break;
            }
            case 1: {
                theSound = ModSounds.FART_B;
                break;
            }
            case 2: {
                theSound = ModSounds.FART_C;
                break;
            }
            case 3: {
                theSound = ModSounds.FART_D;
                break;
            }
            default: {
                theSound = ModSounds.FART_E;
            }
        }
        theWorld.func_184133_a(null, thePosition, theSound, SoundCategory.MASTER, 1.0f, 1.0f);
    }
}

