/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeMaker;
import mezz.jei.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeChecker;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FurnaceFuelCategory;
import mezz.jei.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import mezz.jei.plugins.vanilla.ingredients.FluidStackHelper;
import mezz.jei.plugins.vanilla.ingredients.FluidStackListFactory;
import mezz.jei.plugins.vanilla.ingredients.FluidStackRenderer;
import mezz.jei.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.plugins.vanilla.ingredients.ItemStackRenderer;
import mezz.jei.startup.StackHelper;
import mezz.jei.transfer.PlayerRecipeTransferHandler;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@JEIPlugin
public class VanillaPlugin
implements IModPlugin {
    @Nullable
    private ISubtypeRegistry subtypeRegistry;

    @Override
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        this.subtypeRegistry = subtypeRegistry;
        subtypeRegistry.registerSubtypeInterpreter(Items.field_185167_i, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_151068_bn, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_185155_bH, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_185156_bI, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter(Items.field_179564_cE, itemStack -> {
            EnumDyeColor baseColor = ItemBanner.func_179225_h((ItemStack)itemStack);
            return baseColor.toString();
        });
        subtypeRegistry.registerSubtypeInterpreter(Items.field_151063_bx, itemStack -> {
            ResourceLocation resourceLocation = ItemMonsterPlacer.func_190908_h((ItemStack)itemStack);
            return resourceLocation == null ? "" : resourceLocation.toString();
        });
        subtypeRegistry.registerSubtypeInterpreter(Items.field_151134_bR, itemStack -> {
            ArrayList<String> enchantmentNames = new ArrayList<String>();
            NBTTagList enchantments = ItemEnchantedBook.func_92110_g((ItemStack)itemStack);
            for (NBTBase nbt : enchantments) {
                NBTTagCompound nbttagcompound;
                short j;
                Enchantment enchantment;
                if (!(nbt instanceof NBTTagCompound) || (enchantment = Enchantment.func_185262_c((int)(j = (nbttagcompound = (NBTTagCompound)nbt).func_74765_d("id")))) == null) continue;
                String enchantmentUid = enchantment.func_77320_a() + ".lvl" + nbttagcompound.func_74765_d("lvl");
                enchantmentNames.add(enchantmentUid);
            }
            enchantmentNames.sort(null);
            return ((Object)enchantmentNames).toString();
        });
    }

    @Override
    public void registerIngredients(IModIngredientRegistration ingredientRegistration) {
        Preconditions.checkState((this.subtypeRegistry != null ? 1 : 0) != 0);
        StackHelper stackHelper = Internal.getStackHelper();
        ItemStackListFactory itemStackListFactory = new ItemStackListFactory(this.subtypeRegistry);
        ingredientRegistration.register(VanillaTypes.ITEM, itemStackListFactory.create(stackHelper), new ItemStackHelper(stackHelper), new ItemStackRenderer());
        ingredientRegistration.register(VanillaTypes.FLUID, FluidStackListFactory.create(), new FluidStackHelper(), new FluidStackRenderer());
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new CraftingRecipeCategory(guiHelper), new FurnaceFuelCategory(guiHelper), new FurnaceSmeltingCategory(guiHelper), new BrewingRecipeCategory(guiHelper), new AnvilRecipeCategory(guiHelper));
    }

    @Override
    public void register(IModRegistry registry) {
        IIngredientRegistry ingredientRegistry = registry.getIngredientRegistry();
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
        registry.addRecipes(CraftingRecipeChecker.getValidRecipes(jeiHelpers), "minecraft.crafting");
        registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes(jeiHelpers), "minecraft.smelting");
        registry.addRecipes(FuelRecipeMaker.getFuelRecipes(ingredientRegistry, jeiHelpers), "minecraft.fuel");
        registry.addRecipes(BrewingRecipeMaker.getBrewingRecipes(ingredientRegistry), "minecraft.brewing");
        registry.addRecipes(TippedArrowRecipeMaker.getTippedArrowRecipes(), "minecraft.crafting");
        registry.addRecipes(AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientRegistry), "minecraft.anvil");
        registry.handleRecipes(ShapedOreRecipe.class, recipe -> new ShapedOreRecipeWrapper(jeiHelpers, (ShapedOreRecipe)recipe), "minecraft.crafting");
        registry.handleRecipes(ShapedRecipes.class, recipe -> new ShapedRecipesWrapper(jeiHelpers, (ShapedRecipes)recipe), "minecraft.crafting");
        registry.handleRecipes(ShapelessOreRecipe.class, recipe -> new ShapelessRecipeWrapper<ShapelessOreRecipe>(jeiHelpers, (ShapelessOreRecipe)recipe), "minecraft.crafting");
        registry.handleRecipes(ShapelessRecipes.class, recipe -> new ShapelessRecipeWrapper<ShapelessRecipes>(jeiHelpers, (ShapelessRecipes)recipe), "minecraft.crafting");
        registry.addRecipeClickArea(GuiCrafting.class, 88, 32, 28, 23, "minecraft.crafting");
        registry.addRecipeClickArea(GuiInventory.class, 137, 29, 10, 13, "minecraft.crafting");
        registry.addRecipeClickArea(GuiBrewingStand.class, 97, 16, 14, 30, "minecraft.brewing");
        registry.addRecipeClickArea(GuiFurnace.class, 78, 32, 28, 23, "minecraft.smelting", "minecraft.fuel");
        registry.addRecipeClickArea(GuiRepair.class, 102, 48, 22, 15, "minecraft.anvil");
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(new PlayerRecipeTransferHandler(jeiHelpers.recipeTransferHandlerHelper()), "minecraft.crafting");
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.smelting", 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.fuel", 1, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerBrewingStand.class, "minecraft.brewing", 0, 4, 5, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerRepair.class, "minecraft.anvil", 0, 2, 3, 36);
        registry.addRecipeCatalyst(new ItemStack(Blocks.field_150462_ai), "minecraft.crafting");
        registry.addRecipeCatalyst(new ItemStack(Blocks.field_150460_al), "minecraft.smelting", "minecraft.fuel");
        registry.addRecipeCatalyst(new ItemStack(Items.field_151067_bt), "minecraft.brewing");
        registry.addRecipeCatalyst(new ItemStack(Blocks.field_150467_bQ), "minecraft.anvil");
        IIngredientBlacklist ingredientBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist(new ItemStack(Items.field_151144_bL, 1, 3));
    }
}

