/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.localization.PlayerMessages;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.nio.BufferOverflowException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.wft.api.IWirelessFluidTerminalItem;
import p455w0rd.wft.init.ModNetworking;
import p455w0rd.wft.sync.packets.PacketInventoryAction;
import p455w0rd.wft.sync.packets.PacketMEFluidInventoryUpdate;
import p455w0rd.wft.sync.packets.PacketTargetFluidStack;
import p455w0rd.wft.sync.packets.PacketValueConfig;

public class ContainerWFT
extends ContainerWT
implements IMEMonitorHandlerReceiver<IAEFluidStack> {
    private final IMEMonitor<IAEFluidStack> monitor;
    private final IItemList<IAEFluidStack> fluids = ((IFluidStorageChannel)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)).createList();
    private IGridNode networkNode;
    private IAEFluidStack clientRequestedTargetFluid = null;

    public ContainerWFT(EntityPlayer player, ITerminalHost hostIn, int slot, boolean isBauble) {
        super(player.field_71071_by, (Object)ContainerWFT.getActionHost((Object)ContainerWFT.getGuiObject((ItemStack)(isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, slot, IWirelessFluidTerminalItem.class) : WTApi.instance().getWTBySlot(player, slot)), (EntityPlayer)player)), slot, isBauble, true, 152, 110);
        this.setCustomName("WFTContainer");
        this.setTerminalHost(hostIn);
        this.initConfig(this.setClientConfigManager((IConfigManager)new ConfigManager((IConfigManagerHost)this)));
        if (Platform.isServer()) {
            this.setServerConfigManager(this.getGuiObject().getConfigManager());
            this.monitor = this.getGuiObject().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                if (this.getGuiObject() instanceof IEnergySource) {
                    this.setPowerSource((IEnergySource)this.getGuiObject());
                } else if (this.getGuiObject() instanceof IGridHost || this.getGuiObject() instanceof IActionHost) {
                    IGrid g;
                    this.networkNode = this.getGuiObject() instanceof IGridHost ? ((IGridHost)this.getGuiObject()).getGridNode(AEPartLocation.INTERNAL) : (this.getGuiObject() instanceof IActionHost ? this.getGuiObject().getActionableNode() : null);
                    if (this.networkNode != null && (g = this.networkNode.getGrid()) != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.getPlayer().func_145747_a(PlayerMessages.CommunicationError.get());
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        for (int i = 0; i < this.getPlayerInv().func_70302_i_(); ++i) {
            ItemStack currStack = this.getPlayerInv().func_70301_a(i);
            if (currStack.func_190926_b() || currStack != this.getWirelessTerminal()) continue;
            this.lockPlayerInventorySlot(i);
        }
        this.bindPlayerInventory(player.field_71071_by, 8, 132);
        this.readNBT();
    }

    protected void initConfig(IConfigManager cm) {
        cm.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        cm.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        cm.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void func_75134_a(EntityPlayer player) {
        this.writeToNBT();
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnStack = ItemStack.field_190927_a;
        try {
            returnStack = super.func_184996_a(slot, dragType, clickTypeIn, player);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.writeToNBT();
        this.func_75142_b();
        return returnStack;
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEFluidInventoryUpdate piu = new PacketMEFluidInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEFluidStack send : monitorCache) {
                    try {
                        piu.appendFluid(send);
                    }
                    catch (BufferOverflowException boe) {
                        ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEFluidInventoryUpdate();
                        piu.appendFluid(send);
                    }
                }
                ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && stack.getFluidStack().isFluidEqual(this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            ModNetworking.instance().sendToServer(new PacketTargetFluidStack((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.getGuiObject() != null) {
                if (this.getWirelessTerminal() != this.getGuiObject().getItemStack()) {
                    if (!this.getWirelessTerminal().func_190926_b()) {
                        if (ItemStack.func_179545_c((ItemStack)this.getGuiObject().getItemStack(), (ItemStack)this.getWirelessTerminal())) {
                            this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.getGuiObject().getItemStack());
                        } else {
                            this.setValidContainer(false);
                        }
                    } else {
                        this.setValidContainer(false);
                    }
                }
            } else {
                this.setValidContainer(false);
            }
            if (this.monitor != this.getTerminalHost().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.getServerConfigManager().getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.getServerConfigManager().getSetting(set);
                if (sideLocal == (sideRemote = this.getClientConfigManager().getSetting(set))) continue;
                this.getClientConfigManager().putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        ModNetworking.instance().sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!this.fluids.isEmpty()) {
                try {
                    IItemList monitorCache = this.monitor.getStorageList();
                    PacketMEFluidInventoryUpdate piu = new PacketMEFluidInventoryUpdate();
                    for (IAEFluidStack is : this.fluids) {
                        IAEFluidStack send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendFluid(is);
                            continue;
                        }
                        piu.appendFluid(send);
                    }
                    if (!piu.isEmpty()) {
                        this.fluids.resetStatus();
                        for (Object c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            super.func_75142_b();
            if (!this.isInRange()) {
                if (!this.hasInfiniteRange()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a(PlayerMessages.OutOfRange.get());
                    }
                    this.setValidContainer(false);
                }
                if (!this.networkIsPowered()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("No Network Power"));
                    }
                    this.setValidContainer(false);
                }
            } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a(PlayerMessages.CommunicationError.get());
                }
                this.setValidContainer(false);
            }
            if (this.getWirelessTerminal().func_77973_b() instanceof IWirelessFluidTerminalItem && ((IWirelessFluidTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal()) <= 0.0) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("No Power"));
                }
                this.setValidContainer(false);
            }
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        boolean isBucket;
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM && action != InventoryAction.SHIFT_CLICK && action != InventoryAction.ROLL_DOWN && action != InventoryAction.ROLL_UP) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held.func_190916_E() > 1) {
            return;
        }
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)held);
        if (fh == null && !held.func_190926_b()) {
            return;
        }
        boolean bl = isBucket = held.func_77973_b() == Items.field_151133_ar || held.func_77973_b() == Items.field_151131_as || held.func_77973_b() == Items.field_151129_at || held.func_77973_b() == Items.field_151117_aB || held.func_77973_b() == ForgeModContainer.getInstance().universalBucket;
        if ((action == InventoryAction.FILL_ITEM || action == InventoryAction.ROLL_UP) && this.clientRequestedTargetFluid != null) {
            AEFluidStack stack = (AEFluidStack)this.clientRequestedTargetFluid.copy();
            AEItemStack bucket = AEItemStack.fromItemStack((ItemStack)new ItemStack(Items.field_151133_ar));
            IAEItemStack bucketInSystem = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getGuiObject().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)), (IAEStack)bucket, (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
            if (held.func_190926_b()) {
                if (bucketInSystem != null) {
                    held = bucketInSystem.createItemStack();
                    fh = FluidUtil.getFluidHandler((ItemStack)held);
                    isBucket = true;
                } else {
                    return;
                }
            }
            if (isBucket && stack.getStackSize() < 1000L) {
                return;
            }
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), false);
            if (action == InventoryAction.ROLL_UP) {
                IAEFluidStack tmpStack = stack.copy();
                tmpStack.setStackSize(1000L);
                amountAllowed = fh.fill(tmpStack.getFluidStack(), false);
            }
            stack.setStackSize((long)amountAllowed);
            IAEFluidStack canPull = (IAEFluidStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)stack, (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L || isBucket && canPull.getStackSize() != 1000L) {
                return;
            }
            IAEFluidStack pulled = (IAEFluidStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)stack, (IActionSource)this.getActionSource());
            if (pulled == null || pulled.getStackSize() < 1L) {
                return;
            }
            if ((held.func_190926_b() || held.func_77973_b() == Items.field_151133_ar) && isBucket) {
                Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getGuiObject().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)), (IAEStack)bucket, (IActionSource)this.getActionSource(), (Actionable)Actionable.MODULATE);
            }
            fh.fill(pulled.getFluidStack(), true);
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
        } else if ((action == InventoryAction.EMPTY_ITEM || action == InventoryAction.ROLL_DOWN) && fh != null) {
            FluidStack extract = fh.drain(action == InventoryAction.ROLL_DOWN ? 1000 : Integer.MAX_VALUE, false);
            if (extract == null || extract.amount < 1) {
                return;
            }
            IAEFluidStack notPushed = (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
            if (isBucket && notPushed != null && notPushed.getStackSize() > 0L) {
                return;
            }
            IAEFluidStack notInserted = (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)this.getActionSource());
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                extract.amount -= Math.toIntExact(notInserted.getStackSize());
            }
            fh.drain(extract, true);
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
        } else if (action == InventoryAction.EMPTY_ITEM && fh == null) {
            ItemStack stack;
            if (player.field_71071_by.func_70445_o().func_190926_b() && (fh = FluidUtil.getFluidHandler((ItemStack)(stack = ((Slot)this.field_75151_b.get(slot)).func_75211_c()))) != null) {
                FluidStack extract = fh.drain(Integer.MAX_VALUE, false);
                if (extract == null || extract.amount < 1) {
                    return;
                }
                IAEFluidStack notPushed = (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)this.getActionSource(), (Actionable)Actionable.SIMULATE);
                if (isBucket && notPushed != null && notPushed.getStackSize() > 0L) {
                    return;
                }
                IAEFluidStack notInserted = (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    extract.amount -= Math.toIntExact(notInserted.getStackSize());
                }
                fh.drain(extract, true);
                ((Slot)this.field_75151_b.get(slot)).func_75215_d(fh.getContainer());
            }
        } else {
            if (action == InventoryAction.ROLL_DOWN) {
                // empty if block
            }
            System.out.println(action);
        }
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                ModNetworking.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isPowered() {
        double pwr = ((ICustomWirelessTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal());
        return pwr > 0.0;
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        return ItemStack.field_190927_a;
    }
}

