/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.network;

import gcewing.sg.BaseDataChannel;
import gcewing.sg.SGCraft;
import gcewing.sg.features.gdo.client.gui.GdoScreen;
import gcewing.sg.features.pdd.client.gui.PddScreen;
import gcewing.sg.network.SGChannel;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class GuiNetworkHandler
extends SGChannel {
    protected static BaseDataChannel guiChannel;

    public GuiNetworkHandler(String name) {
        super(name);
        guiChannel = this;
    }

    public static void sendGuiRequestToServer(SGBaseTE te, EntityPlayer player, int guiType) {
        BaseDataChannel.ChannelOutput data = guiChannel.openServer("requestGUI");
        GuiNetworkHandler.writeCoords(data, te);
        data.writeInt(guiType);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="requestGUI")
    public void handleGUIRequestFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        int guiType;
        BlockPos pos = this.readCoords(data);
        SGBaseTE localGate = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        boolean canAccessLocal = localGate.allowGateAccess(player.func_70005_c_());
        boolean canEditRemote = false;
        if (localGate.isConnected() && localGate.state == SGState.Connected) {
            SGBaseTE remoteGate = localGate.getConnectedStargateTE();
            canEditRemote = remoteGate.allowGateAccess(player.func_70005_c_());
        }
        if ((guiType = data.readInt()) == 1) {
            if (SGCraft.hasPermission(player, "sgcraft.gui.configurator")) {
                if (canAccessLocal) {
                    GuiNetworkHandler.openGuiAtClient(localGate, player, 1, SGCraft.hasPermission(player, "sgcraft.admin"), canAccessLocal, canEditRemote);
                } else {
                    SGBaseTE.sendErrorMsg(player, "insufficientGatePermission", new Object[0]);
                }
            } else {
                SGBaseTE.sendErrorMsg(player, "configuratorPermission", new Object[0]);
            }
        }
        if (guiType == 2) {
            if (SGCraft.hasPermission(player, "sgcraft.gui.gdo")) {
                GuiNetworkHandler.openGuiAtClient(localGate, player, 2, SGCraft.hasPermission(player, "sgcraft.admin"), canAccessLocal, canEditRemote);
            } else {
                SGBaseTE.sendErrorMsg(player, "gdoPermission", new Object[0]);
            }
        }
    }

    public static void openGuiAtClient(SGBaseTE te, EntityPlayer player, int guiType, boolean isAdmin, boolean canEditLocal, boolean canEditRemote) {
        BaseDataChannel.ChannelOutput data = guiChannel.openPlayer(player, "OpenGUI");
        GuiNetworkHandler.writeCoords(data, te);
        data.writeInt(guiType);
        data.writeBoolean(isAdmin);
        data.writeBoolean(canEditLocal);
        data.writeBoolean(canEditRemote);
        if (guiType == 2) {
            data.writeBoolean(te.isConnected() && te.state == SGState.Connected);
            if (te.isConnected() && te.state == SGState.Connected) {
                SGBaseTE remoteGate = te.getConnectedStargateTE();
                data.writeBoolean(remoteGate.hasIrisUpgrade);
                data.writeBoolean(remoteGate.hasChevronUpgrade);
                data.writeBoolean(remoteGate.irisIsClosed());
                data.writeInt(remoteGate.gateType);
                data.writeUTF(SGAddressing.formatAddress(remoteGate.homeAddress, "-", "-"));
            }
        }
        data.close();
    }

    @BaseDataChannel.ClientMessageHandler(value="OpenGUI")
    public void handleGuiOpenRequest(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        int guiType = data.readInt();
        boolean isAdmin = data.readBoolean();
        boolean canAccessLocal = data.readBoolean();
        boolean canAccessRemote = data.readBoolean();
        if (guiType == 1) {
            // empty if block
        }
        if (guiType == 2) {
            boolean r_connected = data.readBoolean();
            boolean r_hasIrisUpgrade = false;
            boolean r_hasChevronUpgrade = false;
            boolean r_isIrisClosed = false;
            int r_gateType = 1;
            String r_address = "";
            if (r_connected) {
                r_hasIrisUpgrade = data.readBoolean();
                r_hasChevronUpgrade = data.readBoolean();
                r_isIrisClosed = data.readBoolean();
                r_gateType = data.readInt();
                r_address = data.readUTF();
            }
            if (Minecraft.func_71410_x().field_71462_r instanceof GdoScreen) {
                GdoScreen screen = (GdoScreen)Minecraft.func_71410_x().field_71462_r;
                screen.isRemoteConnected = r_connected;
                screen.r_hasIrisUpgrade = r_hasIrisUpgrade;
                screen.r_hasChevronUpgrade = r_hasIrisUpgrade;
                screen.r_isIrisClosed = r_isIrisClosed;
                screen.r_gateType = r_gateType;
                screen.r_address = r_address;
            } else {
                new GdoScreen(player, player.field_70170_p, isAdmin, r_connected, r_hasIrisUpgrade, r_hasChevronUpgrade, r_isIrisClosed, r_gateType, r_address, canAccessLocal, canAccessRemote).display();
            }
        }
        if (guiType == 3) {
            new PddScreen(player, player.field_70170_p, isAdmin).display();
        }
    }
}

