/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import javax.annotation.Nullable;
import lumien.randomthings.block.BlockBase;
import lumien.randomthings.item.ItemIngredient;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.INoItem;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLotus
extends BlockBase
implements IPlantable,
INoItem {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.3125, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5625, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)};

    public BlockLotus() {
        super("lotus", Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149647_a(null);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ModItems.lotusSeeds);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.lotusSeeds;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3) {
            if (worldIn.field_72995_K) {
                return true;
            }
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
            playerIn.func_191521_c(new ItemStack((Item)ModItems.ingredients, 1, ItemIngredient.INGREDIENT.LOTUS_BLOSSOM.id));
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3 && rand.nextInt(10) == 0) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(worldIn.func_180495_p(pos.func_177977_b()));
    }
}

