/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.UUID;
import lumien.randomthings.block.BlockSpectreCoil;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.handler.spectrecoils.SpectreCoilHandler;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntitySpectreCoil
extends TileEntityBase
implements ITickable {
    UUID owner;
    BlockSpectreCoil.CoilType coilType = BlockSpectreCoil.CoilType.NORMAL;

    public TileEntitySpectreCoil(BlockSpectreCoil.CoilType coilType) {
        this.coilType = coilType;
    }

    public TileEntitySpectreCoil() {
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("coilType", this.coilType.ordinal());
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.coilType = BlockSpectreCoil.CoilType.values()[compound.func_74762_e("coilType")];
        if (compound.func_74764_b("owner")) {
            this.owner = UUID.fromString(compound.func_74779_i("owner"));
        }
    }

    @Override
    public boolean syncAdditionalData() {
        return false;
    }

    public void setOwner(UUID id) {
        this.owner = id;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        EnumFacing myFacing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSpectreCoil.FACING)).func_176734_d();
        if (myFacing == facing && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        EnumFacing myFacing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSpectreCoil.FACING)).func_176734_d();
        if (myFacing == facing && capability == CapabilityEnergy.ENERGY) {
            return (T)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public int getMaxEnergyStored() {
                    return 0;
                }

                public int getEnergyStored() {
                    return 0;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public boolean canReceive() {
                    return false;
                }

                public boolean canExtract() {
                    return false;
                }
            };
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        EnumFacing facing;
        TileEntity targetTe;
        if (!this.field_145850_b.field_72995_K && this.owner != null && (targetTe = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSpectreCoil.FACING)).func_176734_d()))) != null) {
            IEnergyStorage targetStorage = null;
            if (targetTe.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
                targetStorage = (IEnergyStorage)targetTe.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
            } else if (targetTe.hasCapability(CapabilityEnergy.ENERGY, null)) {
                targetStorage = (IEnergyStorage)targetTe.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (targetStorage != null && targetStorage.canReceive()) {
                if (this.coilType == BlockSpectreCoil.CoilType.NUMBER || this.coilType == BlockSpectreCoil.CoilType.GENESIS) {
                    int amount = this.coilType == BlockSpectreCoil.CoilType.NUMBER ? Numbers.NUMBERED_SPECTRECOIL_ENERGY : 10000000;
                    targetStorage.receiveEnergy(amount, false);
                } else {
                    IEnergyStorage coilStorage = SpectreCoilHandler.get(this.field_145850_b).getStorageCoil(this.owner);
                    int rate = 1;
                    if (this.coilType == BlockSpectreCoil.CoilType.NORMAL) {
                        rate = 1024;
                    } else if (this.coilType == BlockSpectreCoil.CoilType.REDSTONE) {
                        rate = 4096;
                    } else if (this.coilType == BlockSpectreCoil.CoilType.ENDER) {
                        rate = 20480;
                    }
                    int available = coilStorage.extractEnergy(rate, true);
                    int remaining = available - targetStorage.receiveEnergy(available, false);
                    if (remaining != available) {
                        coilStorage.extractEnergy(available - remaining, false);
                    }
                }
            }
        }
    }
}

