/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.multiblocks;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockBlockType;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Multiblock
implements Iterable<MultiblockLayer> {
    private Map<Integer, MultiblockLayer> layers = new HashMap<Integer, MultiblockLayer>();
    private List<Integer> layerIndices = new ArrayList<Integer>();
    private Map<String, MultiblockBlockType> blocks = new HashMap<String, MultiblockBlockType>();
    private Map<Integer, MultiblockLayer> output = new HashMap<Integer, MultiblockLayer>();
    private int topY = -100;
    private int bottomY = 100;
    private String name;
    private IBlockState keyBlock;
    private ResourceLocation id;

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public Map<Integer, MultiblockLayer> getLayers() {
        return this.layers;
    }

    public List<Integer> getLayerIndices() {
        return this.layerIndices;
    }

    public Map<String, MultiblockBlockType> getBlocks() {
        return this.blocks;
    }

    public int getTopY() {
        return this.topY;
    }

    public int getBottomY() {
        return this.bottomY;
    }

    public String getName() {
        return this.name;
    }

    public IBlockState getKeyBlock() {
        return this.keyBlock;
    }

    public Multiblock(Path filename) throws IOException {
        InputStream in = Files.newInputStream(filename, new OpenOption[0]);
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
            Gson gson = new Gson();
            JsonObject jsonObject = new JsonObject();
            JsonParser parser = new JsonParser();
            jsonObject = parser.parse(reader).getAsJsonObject();
            if (!jsonObject.has("name")) {
                throw new Exception("Multiblock json malformed, missing name ");
            }
            this.name = jsonObject.get("name").getAsString();
            if (!jsonObject.has("id")) {
                throw new Exception("Multiblock json malformed, missing id");
            }
            this.id = new ResourceLocation(jsonObject.get("id").getAsString());
            if (!jsonObject.has("keyBlock")) {
                throw new Exception("Multiblock json malformed, missing keyBlock");
            }
            Block keyBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"keyBlock")));
            if (keyBlock instanceof BlockAir) {
                return;
            }
            int meta = 0;
            if (jsonObject.has("keyMeta")) {
                meta = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"keyMeta");
            }
            this.keyBlock = keyBlock.func_176203_a(meta);
            if (!jsonObject.has("blocks")) {
                throw new Exception("Multiblock json malformed, missing blocks array ");
            }
            JsonElement blocksElement = jsonObject.get("blocks");
            JsonArray blocksArray = blocksElement.getAsJsonArray();
            for (JsonElement blockElement : blocksArray) {
                MultiblockBlockType block = new MultiblockBlockType(blockElement.getAsJsonObject());
                this.blocks.put(block.getBlockName(), block);
            }
            if (!jsonObject.has("layers")) {
                throw new Exception("Multiblock json malformed, missing layers array ");
            }
            JsonElement layersElement = jsonObject.get("layers");
            JsonArray layersArray = layersElement.getAsJsonArray();
            for (JsonElement layerElement : layersArray) {
                MultiblockLayer layer = new MultiblockLayer(layerElement.getAsJsonObject());
                this.AddLayer(layer.getyLevel(), layer);
            }
            if (jsonObject.has("output")) {
                JsonElement outputsElement = jsonObject.get("output");
                JsonArray outputArray = outputsElement.getAsJsonArray();
                for (JsonElement outputElement : outputArray) {
                    MultiblockLayer layer = new MultiblockLayer(outputElement.getAsJsonObject());
                    this.AddOutputLayer(layer.getyLevel(), layer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void AddOutputLayer(int yLevel, MultiblockLayer layer) {
        this.output.put(yLevel, layer);
        if (!this.layerIndices.contains(yLevel)) {
            this.layerIndices.add(yLevel);
        }
        if (yLevel > this.topY) {
            this.topY = yLevel;
        }
        if (yLevel < this.bottomY) {
            this.bottomY = yLevel;
        }
    }

    public void AddLayer(int yLevel, MultiblockLayer layer) {
        this.layers.put(yLevel, layer);
        this.layerIndices.add(yLevel);
        this.layerIndices.sort(Comparator.reverseOrder());
        if (yLevel > this.topY) {
            this.topY = yLevel;
        }
        if (yLevel < this.bottomY) {
            this.bottomY = yLevel;
        }
    }

    @Override
    @NotNull
    public Iterator<MultiblockLayer> iterator() {
        return new Iterator<MultiblockLayer>(){
            private int current;
            {
                this.current = Multiblock.this.bottomY - 1;
            }

            @Override
            public boolean hasNext() {
                return this.current < Multiblock.this.topY;
            }

            @Override
            public MultiblockLayer next() {
                while (!Multiblock.this.layerIndices.contains(++this.current)) {
                }
                return (MultiblockLayer)Multiblock.this.layers.get(this.current);
            }
        };
    }

    public Iterator<MultiblockLayer> outputIterator() {
        return new Iterator<MultiblockLayer>(){
            private int current;
            {
                this.current = Multiblock.this.bottomY - 1;
            }

            @Override
            public boolean hasNext() {
                return this.current < Multiblock.this.topY;
            }

            @Override
            public MultiblockLayer next() {
                while (!Multiblock.this.output.containsKey(++this.current) && this.current < Multiblock.this.topY) {
                }
                if (!Multiblock.this.output.containsKey(this.current)) {
                    return null;
                }
                return (MultiblockLayer)Multiblock.this.output.get(this.current);
            }
        };
    }

    public Iterator<MultiblockLayer> combinedIterator() {
        return new Iterator<MultiblockLayer>(){
            private int current;
            {
                this.current = Multiblock.this.bottomY - 1;
            }

            @Override
            public boolean hasNext() {
                return this.current < Multiblock.this.topY;
            }

            @Override
            public MultiblockLayer next() {
                do {
                    ++this.current;
                    if (Multiblock.this.output.containsKey(this.current)) {
                        return (MultiblockLayer)Multiblock.this.output.get(this.current);
                    }
                    if (!Multiblock.this.layers.containsKey(this.current)) continue;
                    return (MultiblockLayer)Multiblock.this.layers.get(this.current);
                } while (this.current < Multiblock.this.topY);
                return null;
            }
        };
    }
}

