/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import ic2.api.classic.audio.IAudioPosition;
import ic2.api.classic.audio.ISoundModifier;
import ic2.api.classic.audio.ISoundProvider;
import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.audio.AudioManagerClient;
import ic2.core.audio.AudioSource;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.MathUtil;
import java.net.URL;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import paulscode.sound.SoundSystem;

public class AudioSourceClient
extends AudioSource {
    private static final float fadingDistance = 16.0f;
    private final AudioManagerClient client;
    private SoundSystem soundSystem;
    private String sourceName;
    private ISoundProvider provider;
    private IAudioPosition position;
    private PositionSpec soundType;
    private boolean valid = false;
    private boolean enabled = true;
    private boolean isPlaying = false;
    private boolean volumeChange = false;
    private float volume;
    private float realVolume;
    private float pitch;

    public AudioSourceClient(AudioManagerClient theClient, SoundSystem soundSystem, String sourceName, ISoundProvider obj, PositionSpec positionSpec, URL url, ResourceLocation soundFile, boolean loop, boolean priorized, float volume, float pitch) {
        this.client = theClient;
        this.soundSystem = soundSystem;
        this.sourceName = sourceName;
        this.provider = obj;
        this.soundType = positionSpec;
        this.position = obj.getAudioPositon();
        Vec3d pos = this.position.getPosition();
        soundSystem.newSource(priorized, sourceName, url, soundFile.toString(), loop, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, 0, 16.0f * Math.max(volume, 0.2f));
        this.valid = true;
        this.setVolume(volume);
        this.pitch = pitch;
    }

    @Override
    public void remove() {
        if (!this.valid) {
            return;
        }
        if (this.enabled && this.isPlaying) {
            this.soundSystem.stop(this.sourceName);
        }
        this.soundSystem.removeSource(this.sourceName);
        this.isPlaying = false;
        this.provider = null;
        this.valid = false;
        this.position = null;
        this.realVolume = 0.0f;
        this.soundSystem = null;
    }

    @Override
    public void play() {
        if (!this.valid) {
            return;
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        if (!this.enabled) {
            return;
        }
        this.soundSystem.play(this.sourceName);
    }

    @Override
    public void pause() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (!this.enabled) {
            return;
        }
        this.soundSystem.pause(this.sourceName);
    }

    @Override
    public void stop() {
        if (!this.valid) {
            return;
        }
        boolean systemPlays = this.soundSystem.playing(this.sourceName);
        if (this.isPlaying) {
            this.isPlaying = false;
        }
        if (!systemPlays) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        this.soundSystem.stop(this.sourceName);
    }

    @Override
    public boolean isPlaying() {
        if (!this.valid) {
            return false;
        }
        if (!this.isPlaying) {
            return false;
        }
        return this.soundSystem.playing(this.sourceName);
    }

    @Override
    public boolean isRemoved() {
        return !this.valid;
    }

    @Override
    public float getVolume() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.soundSystem.getVolume(this.sourceName);
    }

    @Override
    public void setVolume(float volume) {
        if (!this.valid) {
            return;
        }
        this.volume = volume;
        this.volumeChange = true;
        this.soundSystem.setVolume(this.sourceName, 1.0E-4f);
    }

    @Override
    public void setPitch(float pitch) {
        if (!this.valid) {
            return;
        }
        this.pitch = pitch;
        this.soundSystem.setPitch(this.sourceName, pitch);
    }

    @Override
    public float getRealVolume() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.realVolume;
    }

    @Override
    public float getPitch() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.pitch;
    }

    @Override
    public void updatePosition() {
        if (!this.valid) {
            return;
        }
        Vec3d pos = this.position.getPosition();
        this.soundSystem.setPosition(this.sourceName, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
    }

    @Override
    public boolean isEnabled() {
        if (!this.valid) {
            return false;
        }
        return this.enabled;
    }

    @Override
    public void enable() {
        if (!this.valid) {
            return;
        }
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.soundSystem.activate(this.sourceName);
        if (this.isPlaying) {
            this.soundSystem.play(this.sourceName);
        }
    }

    @Override
    public void dissable() {
        if (!this.valid) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.isPlaying = this.soundSystem.playing(this.sourceName);
        if (this.isPlaying) {
            this.soundSystem.stop(this.sourceName);
        }
        this.soundSystem.cull(this.sourceName);
    }

    @Override
    public IAudioPosition getPosition() {
        return this.position;
    }

    @Override
    public void updateVolume(EntityPlayer player) {
        if (!this.valid) {
            this.realVolume = 0.0f;
            return;
        }
        float multiplier = this.volume;
        multiplier *= this.getSoundModifiers(this.soundType);
        multiplier *= IC2.audioManager.getVolumeForType(this.soundType);
        multiplier *= IC2.audioManager.getMasterVolume();
        double maxDistance = (multiplier /= this.volume) > 1.0f ? (double)(16.0f * multiplier * Math.max(this.volume, 0.2f)) : (double)(16.0f * Math.max(this.volume, 0.2f));
        double distance = 1.0;
        Vec3d startPosition = player.func_174791_d();
        if (this.matchDimension(player)) {
            distance = this.position.getPosition().func_72438_d(startPosition);
        }
        if (distance > maxDistance) {
            this.realVolume = 0.0f;
            this.dissable();
            return;
        }
        this.enable();
        if (distance < 1.0) {
            distance = 1.0;
        }
        float newRealVolume = (float)((double)this.volume * (1.0 - 1.0 * (distance - 1.0) / (maxDistance - 1.0)));
        if ((newRealVolume *= multiplier) > 0.1f) {
            Vec3d perStep = MathUtil.substract(this.position.getPosition().func_178788_d(startPosition), (float)distance);
            int i = 0;
            while ((double)i < distance) {
                IBlockState state = player.field_70170_p.func_180495_p(new BlockPos(startPosition));
                if (state.func_177230_c() != Blocks.field_150350_a) {
                    newRealVolume = state.func_185914_p() ? (newRealVolume *= 0.6f) : (newRealVolume *= 0.8f);
                }
                startPosition = startPosition.func_178787_e(perStep);
                ++i;
            }
        }
        if ((double)Math.abs(this.realVolume / newRealVolume - 1.0f) > 0.06 || this.volumeChange) {
            this.soundSystem.setVolume(this.sourceName, newRealVolume);
        } else {
            this.soundSystem.setVolume(this.sourceName, 0.0f);
        }
        this.realVolume = newRealVolume;
    }

    private boolean matchDimension(EntityPlayer player) {
        return this.getDimensionID(this.position.getWorld()) == this.getDimensionID(player.func_130014_f_());
    }

    private int getDimensionID(World world) {
        if (world == null) {
            return 0;
        }
        return world.field_73011_w.getDimension();
    }

    private float getSoundModifiers(PositionSpec spec) {
        ISoundModifier modifier;
        float result = 1.0f;
        Iterator<ISoundModifier> iterator = this.client.getModifiers().iterator();
        while (!(!iterator.hasNext() || (modifier = iterator.next()).hasEffect(spec) && this.isInRange(modifier, spec) && (result *= modifier.getAudioEffect(spec)) <= 0.0f)) {
        }
        return result;
    }

    private boolean isInRange(ISoundModifier modifier, PositionSpec spec) {
        BlockPos pos;
        AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(modifier.getPosition().getPosition(), modifier.getEffectRange(spec));
        return box.intersectsWith(pos = new BlockPos(this.position.getPosition()));
    }
}

