/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.core;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPStaticConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.core.RPClassWriter;
import com.therandomlabs.randompatches.patch.NetHandlerPlayServerPatch;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class RPTransformer
implements IClassTransformer {
    private static final Map<String, Patch> PATCHES = new HashMap<String, Patch>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Patch patch = PATCHES.get(transformedName);
        if (patch == null) {
            return basicClass;
        }
        RandomPatches.LOGGER.debug("Patching class: " + transformedName);
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        try {
            patch.apply(node);
            int flags = RandomPatches.SPONGEFORGE_INSTALLED && patch.getClass() == NetHandlerPlayServerPatch.class ? 1 : 2;
            RPClassWriter writer = new RPClassWriter(flags);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Exception ex) {
            RandomPatches.LOGGER.error("Failed to apply class: " + transformedName, (Throwable)ex);
            return basicClass;
        }
    }

    public static void register(String className, Patch patch) {
        PATCHES.put(className, patch);
    }

    static {
        RPStaticConfig.reload();
        RandomPatches.registerPatches();
    }
}

