/*
 * Decompiled with CFR 0.152.
 */
package nc.block;

import java.util.Random;
import nc.NuclearCraft;
import nc.config.NCConfig;
import nc.tab.NCTabs;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class NCBlockMushroom
extends BlockMushroom {
    public NCBlockMushroom(String name) {
        this.func_149663_c("nuclearcraft." + name);
        if (NuclearCraft.regName) {
            this.setRegistryName(new ResourceLocation("nuclearcraft", name));
        }
        this.func_149647_a(NCTabs.BASE_BLOCK_MATERIALS);
        this.func_149715_a(1.0f);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (NCConfig.mushroom_spread_rate <= 0) {
            return;
        }
        int spreadTime = 400 / NCConfig.mushroom_spread_rate;
        if (spreadTime <= 0) {
            spreadTime = 1;
        }
        if (rand.nextInt(spreadTime) == 0) {
            int shroomCheck = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (world.func_180495_p(blockpos).func_177230_c() != this || --shroomCheck > 0) continue;
                return;
            }
            BlockPos newPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.func_175623_d(newPos) && this.func_180671_f(world, newPos, this.func_176223_P())) {
                    pos = newPos;
                }
                newPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (world.func_175623_d(newPos) && this.func_180671_f(world, newPos, this.func_176223_P())) {
                world.func_180501_a(newPos, this.func_176223_P(), 2);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }
}

