/*
 * Decompiled with CFR 0.152.
 */
package nc.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.fluid.Tank;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;

public abstract class NCGui
extends GuiContainer {
    public NCGui(Container inventory) {
        super(inventory);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.renderTooltips(mouseX, mouseY);
    }

    public void renderTooltips(int mouseX, int mouseY) {
    }

    public void drawTooltip(List<String> text, int mouseX, int mouseY, int x, int y, int width, int height) {
        int xPos = x + this.field_147003_i;
        int yPos = y + this.field_147009_r;
        if (mouseX >= xPos && mouseY >= yPos && mouseX < xPos + width && mouseY < yPos + height) {
            this.func_146283_a(text, mouseX, mouseY);
        }
    }

    public void drawTooltip(String text, int mouseX, int mouseY, int x, int y, int width, int height) {
        ArrayList stringList = Lists.newArrayList((Object[])new String[]{text});
        this.drawTooltip(stringList, mouseX, mouseY, x, y, width, height);
    }

    public List<String> fluidInfo(Tank tank) {
        String fluidName = tank.getFluidLocalizedName();
        String fluidAmount = UnitHelper.prefix((long)tank.getFluidAmount(), (long)tank.getCapacity(), 5, "B", -1);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.GREEN + fluidName + TextFormatting.WHITE + " [" + fluidAmount + "]", TextFormatting.ITALIC + Lang.localise("gui.container.shift_clear_tank")});
    }

    public void drawFluidTooltip(Tank tank, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        this.drawTooltip(this.fluidInfo(tank), mouseX, mouseY, x, y, width, height + 1);
    }

    public List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), 5, "RF");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy});
    }

    public List<String> noEnergyInfo() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.RED + Lang.localise("gui.container.no_energy")});
    }

    public void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.energyInfo(tile), mouseX, mouseY, x, y, width, height);
    }

    public void drawNoEnergyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.noEnergyInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected int width(String string) {
        return this.field_146289_q.func_78256_a(string);
    }

    protected int widthHalf(String string) {
        return this.width(string) / 2;
    }
}

