/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import com.google.common.math.DoubleMath;
import nc.multiblock.gui.GuiMultiblockController;
import nc.multiblock.gui.element.MultiblockButton;
import nc.multiblock.network.ClearAllFluidsPacket;
import nc.multiblock.turbine.Turbine;
import nc.network.PacketHandler;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.StringHelper;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTurbineController
extends GuiMultiblockController<Turbine> {
    protected final ResourceLocation gui_texture = new ResourceLocation("nuclearcraft:textures/gui/container/turbine_controller.png");

    public GuiTurbineController(Turbine multiblock, BlockPos controllerPos, Container container) {
        super(multiblock, controllerPos, container);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        if (GuiTurbineController.func_146272_n()) {
            this.drawTooltip(this.clearAllFluidsInfo(), mouseX, mouseY, 162, 152, 9, 9);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = ((Turbine)this.multiblock).isTurbineOn ? -1 : 0xEEAA00;
        String title = ((Turbine)this.multiblock).getInteriorLengthX() + "*" + ((Turbine)this.multiblock).getInteriorLengthY() + "*" + ((Turbine)this.multiblock).getInteriorLengthZ() + " " + Lang.localise("gui.container.turbine_controller.turbine");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.width(title) / 2, 6, fontColor);
        String underline = StringHelper.charLine('-', MathHelper.func_76143_f((double)((double)this.width(title) / (double)this.width("-"))));
        this.field_146289_q.func_78276_b(underline, this.field_146999_f / 2 - this.width(underline) / 2, 12, fontColor);
        String power = Lang.localise("gui.container.turbine_controller.power") + " " + UnitHelper.prefix(Math.round(((Turbine)this.multiblock).power), 6, "RF/t");
        this.field_146289_q.func_78276_b(power, this.field_146999_f / 2 - this.width(power) / 2, 24, fontColor);
        String coils = Lang.localise("gui.container.turbine_controller.dynamo_coil_count") + " " + (((Turbine)this.multiblock).getRotorBearings().size() == 0 ? "0/0 [0%]" : ((Turbine)this.multiblock).getDynamoCoils().size() + "/" + ((Turbine)this.multiblock).getRotorBearings().size() + " [" + Math.min(100L, Math.round(100.0 * (double)((Turbine)this.multiblock).getDynamoCoils().size() / (double)((Turbine)this.multiblock).getRotorBearings().size())) + "%]");
        this.field_146289_q.func_78276_b(coils, this.field_146999_f / 2 - this.width(coils) / 2, 36, fontColor);
        String expansion_level = Lang.localise("gui.container.turbine_controller.expansion_level") + " " + (((Turbine)this.multiblock).idealTotalExpansionLevel <= 0.0 ? "0%" : NCMath.decimalPlaces(100.0 * ((Turbine)this.multiblock).totalExpansionLevel, 1) + "% [" + (DoubleMath.isMathematicalInteger((double)((Turbine)this.multiblock).idealTotalExpansionLevel) ? new Integer((int)((Turbine)this.multiblock).idealTotalExpansionLevel).toString() : NCMath.decimalPlaces(((Turbine)this.multiblock).idealTotalExpansionLevel, 1)) + " x " + NCMath.decimalPlaces(100.0 * (((Turbine)this.multiblock).totalExpansionLevel / ((Turbine)this.multiblock).idealTotalExpansionLevel), 1) + "%]");
        this.field_146289_q.func_78276_b(expansion_level, this.field_146999_f / 2 - this.width(expansion_level) / 2, 48, fontColor);
        String fluid_rate = Lang.localise("gui.container.turbine_controller.fluid_rate") + " " + UnitHelper.prefix((long)Math.round(((Turbine)this.multiblock).getActualInputRate()), 6, "B/t", -1) + " [" + Math.round(100.0 * (double)((Turbine)this.multiblock).getActualInputRate() / (double)((Turbine)this.multiblock).getMaxRecipeRateMultiplier()) + "%]";
        this.field_146289_q.func_78276_b(fluid_rate, this.field_146999_f / 2 - this.width(fluid_rate) / 2, 60, fontColor);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ButtonClearAllFluids(0, this.field_147003_i + 162, this.field_147009_r + 152));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((Turbine)this.multiblock).WORLD.field_72995_K && guiButton.field_146127_k == 0 && GuiTurbineController.func_146272_n()) {
            PacketHandler.instance.sendToServer((IMessage)new ClearAllFluidsPacket(this.controllerPos));
        }
    }
}

