/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.IIngredient;
import nc.recipe.IRecipeStack;
import nc.recipe.SorptionType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeTransposable
implements IIngredient,
IRecipeStack {
    public ArrayList<IIngredient> validInputList;
    public ArrayList<Object> cachedObjects = new ArrayList();

    public RecipeTransposable(ArrayList<IIngredient> validInputs) {
        this.validInputList = validInputs;
        validInputs.forEach(input -> this.cachedObjects.add(input.getIngredient()));
    }

    public Object getIngredient() {
        return this.cachedObjects;
    }

    public int getStackSize() {
        return this.validInputList.get(0).getStackSize();
    }

    public List<Object> getIngredientList() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.validInputList.forEach(object -> object.getIngredientList().forEach(obj -> values.add(obj)));
        return values;
    }

    public boolean matches(Object object, SorptionType sorption) {
        for (IIngredient ingredient : this.validInputList) {
            if (!ingredient.matches(object, sorption)) continue;
            return true;
        }
        return false;
    }

    public Object getOutputStack() {
        IIngredient obj = this.validInputList.get(0);
        if (obj instanceof IRecipeStack) {
            return ((IRecipeStack)obj).getOutputStack();
        }
        for (Object object : this.cachedObjects) {
            if (object instanceof ItemStack) {
                return (ItemStack)object;
            }
            if (!(object instanceof FluidStack)) continue;
            return (FluidStack)object;
        }
        return null;
    }
}

