/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import java.util.List;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.IBufferable;

public interface IProcessor
extends IInterfaceable,
IBufferable {
    public void refreshRecipe();

    public void refreshActivity();

    public void refreshActivityOnProduction();

    public static double maxStat(ProcessorRecipeHandler recipeHandler, int i) {
        double max = 1.0;
        List recipes = recipeHandler.getRecipes();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null || recipe.extras().size() <= i || !(recipe.extras().get(i) instanceof Double)) continue;
            max = Math.max(max, (Double)recipe.extras().get(i));
        }
        return max;
    }

    public static double maxBaseProcessTime(ProcessorRecipeHandler recipeHandler, int defaultProcessTime) {
        return IProcessor.maxStat(recipeHandler, 0) * (double)defaultProcessTime;
    }

    public static double maxBaseProcessPower(ProcessorRecipeHandler recipeHandler, int defaultProcessPower) {
        return IProcessor.maxStat(recipeHandler, 1) * (double)defaultProcessPower;
    }

    public static int getCapacity(ProcessorRecipeHandler recipeHandler, int defaultProcessTime, double speedMultiplier, int defaultProcessPower, double powerMultiplier) {
        return Math.max(1, (int)Math.round(Math.ceil(IProcessor.maxBaseProcessTime(recipeHandler, defaultProcessTime) / speedMultiplier))) * Math.min(Integer.MAX_VALUE, (int)(IProcessor.maxBaseProcessPower(recipeHandler, defaultProcessPower) * powerMultiplier));
    }
}

