/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannels;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RedstoneScreenModule
implements IScreenModule<IModuleDataInteger> {
    private int channel = -1;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private int dim = 0;
    private EnumFacing side = null;

    @Override
    public IModuleDataInteger getData(IScreenDataHelper helper, World worldObj, long millis) {
        if (this.channel == -1) {
            WorldServer world;
            if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && (world = DimensionManager.getWorld((int)this.dim)) != null) {
                int powerTo = world.func_175651_c(this.coordinate.func_177972_a(this.side), this.side.func_176734_d());
                return helper.createInteger(powerTo);
            }
            return null;
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
        if (channels == null) {
            return null;
        }
        RedstoneChannels.RedstoneChannel ch = channels.getChannel(this.channel);
        if (ch == null) {
            return null;
        }
        return helper.createInteger(ch.getValue());
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.channel = -1;
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            if (tagCompound.func_74764_b("monitorx")) {
                this.side = EnumFacing.field_82609_l[tagCompound.func_74762_e("monitorside")];
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.REDSTONE_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

