/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.crafttweaker;

import appeng.api.AEApi;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.IInscriberRecipeBuilder;
import appeng.api.features.IInscriberRegistry;
import appeng.api.features.InscriberProcessType;
import appeng.integration.modules.crafttweaker.CTModule;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.appliedenergistics2.Inscriber")
public class InscriberRecipes {
    private InscriberRecipes() {
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, boolean inscribe, @stanhebben.zenscript.annotations.Optional IIngredient top, @stanhebben.zenscript.annotations.Optional IIngredient bottom) {
        Optional<Collection<ItemStack>> inStacks = CTModule.toStacks(input);
        if (!inStacks.isPresent()) {
            return;
        }
        Collection topList = CTModule.toStacks(top).orElse(Collections.singleton(ItemStack.field_190927_a));
        Collection bottomList = CTModule.toStacks(bottom).orElse(Collections.singleton(ItemStack.field_190927_a));
        for (ItemStack topStack : topList) {
            for (ItemStack bottomStack : bottomList) {
                IInscriberRecipeBuilder builder = AEApi.instance().registries().inscriber().builder();
                builder.withProcessType(inscribe ? InscriberProcessType.INSCRIBE : InscriberProcessType.PRESS).withOutput(CTModule.toStack(output)).withInputs(inStacks.get());
                if (!topStack.func_190926_b()) {
                    builder.withTopOptional(topStack);
                }
                if (!bottomStack.func_190926_b()) {
                    builder.withBottomOptional(bottomStack);
                }
                CTModule.MODIFICATIONS.add(new Add(builder.build()));
            }
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CTModule.MODIFICATIONS.add(new Remove((ItemStack)output.getInternal()));
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        private Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            IInscriberRegistry inscriber = AEApi.instance().registries().inscriber();
            inscriber.getRecipes().stream().filter(r -> r.getOutput().func_77969_a(this.stack)).collect(Collectors.toList()).forEach(inscriber::removeRecipe);
        }

        public String describe() {
            return "Removing Inscriber Entry for " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final IInscriberRecipe entry;

        private Add(IInscriberRecipe entry) {
            this.entry = entry;
        }

        public void apply() {
            AEApi.instance().registries().inscriber().addRecipe(this.entry);
        }

        public String describe() {
            return "Adding Inscriber Entry for " + this.entry.getOutput().func_82833_r();
        }
    }
}

