/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.tile.IUpgradeable;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.gui.builder.slot.GuiFluidConfiguration;
import reborncore.client.gui.builder.slot.GuiSlotConfiguration;
import reborncore.client.gui.builder.widget.GuiButtonHologram;
import reborncore.client.gui.builder.widget.GuiButtonPowerBar;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.StringUtils;

public class GuiBase
extends GuiContainer {
    public int field_146999_f = 176;
    public int field_147000_g = 176;
    public GuiBuilder builder = new GuiBuilder();
    public TileEntity tile;
    public BuiltContainer container;
    public static SlotConfigType slotConfigType = SlotConfigType.NONE;
    public static ItemStack wrenchStack = ItemStack.field_190927_a;
    public static FluidCellProvider fluidCellProvider = fluid -> ItemStack.field_190927_a;
    public boolean upgrades;

    public GuiBase(EntityPlayer player, TileEntity tile, BuiltContainer container) {
        super((Container)container);
        this.tile = tile;
        this.container = container;
        slotConfigType = SlotConfigType.NONE;
    }

    protected void drawSlot(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_147003_i;
            y += this.field_147009_r;
        }
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1);
    }

    protected void drawOutputSlotBar(int x, int y, int count, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_147003_i;
            y += this.field_147009_r;
        }
        this.builder.drawOutputSlotBar(this, x - 4, y - 4, count);
    }

    protected void drawArmourSlots(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_147003_i;
            y += this.field_147009_r;
        }
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18 + 18);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18 + 18 + 18);
    }

    protected void drawOutputSlot(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_147003_i;
            y += this.field_147009_r;
        }
        this.builder.drawOutputSlot((GuiScreen)this, x - 5, y - 5);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiSlotConfiguration.init(this);
        if (this.getMachine().getTank() != null && this.getMachine().showTankConfig()) {
            GuiFluidConfiguration.init(this);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int offset;
        IUpgradeable upgradeable;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.builder.drawDefaultBackground((GuiScreen)this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.drawPlayerSlots()) {
            this.builder.drawPlayerSlots((GuiScreen)this, this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 93, true);
        }
        if (this.tryAddUpgrades() && this.tile instanceof IUpgradeable && (upgradeable = (IUpgradeable)this.tile).canBeUpgraded()) {
            this.builder.drawUpgrades(this, this.field_147003_i - 24, this.field_147009_r + 6);
            this.upgrades = true;
        }
        int n = offset = this.upgrades ? 86 : 6;
        if (this.getMachine().hasSlotConfig()) {
            this.builder.drawSlotTab(this, this.field_147003_i - 24, this.field_147009_r + offset, wrenchStack);
        }
        if (this.getMachine().showTankConfig()) {
            this.builder.drawSlotTab(this, this.field_147003_i - 24, this.field_147009_r + 24 + offset, fluidCellProvider.provide(FluidRegistry.LAVA));
        }
    }

    public boolean drawPlayerSlots() {
        return true;
    }

    public boolean tryAddUpgrades() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146292_n.clear();
        this.drawTitle();
        if (slotConfigType == SlotConfigType.ITEMS && this.getMachine().hasSlotConfig()) {
            GuiSlotConfiguration.draw(this, mouseX, mouseY);
        }
        if (slotConfigType == SlotConfigType.FLUIDS && this.getMachine().showTankConfig()) {
            GuiFluidConfiguration.draw(this, mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        int offset;
        if (this.func_146978_c(-25, 6, 24, 80, mouseX, mouseY) && this.upgrades) {
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add(StringUtils.t("reborncore.gui.tooltip.upgrades"));
            this.func_146283_a(list2, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int n = offset = this.upgrades ? 81 : 0;
        if (this.func_146978_c(-26, 6 + offset, 24, 24, mouseX, mouseY) && this.getMachine().hasSlotConfig()) {
            list = new ArrayList<String>();
            list.add(StringUtils.t("reborncore.gui.tooltip.config_slots"));
            this.func_146283_a(list, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.func_146978_c(-26, 6 + offset + 25, 24, 24, mouseX, mouseY) && this.getMachine().showTankConfig()) {
            list = new ArrayList();
            list.add(StringUtils.t("reborncore.gui.tooltip.config_fluids"));
            this.func_146283_a(list, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void drawTitle() {
        this.drawCentredString(I18n.func_135052_a((String)(this.tile.func_145838_q().func_149739_a() + ".name"), (Object[])new Object[0]), 6, 0x404040, Layer.FOREGROUND);
    }

    public void drawCentredString(String string, int y, int colour, Layer layer) {
        this.drawString(string, this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(string) / 2, y, colour, layer);
    }

    protected void drawCentredString(String string, int y, int colour, int modifier, Layer layer) {
        this.drawString(string, this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(string) / 2 + modifier, y, colour, layer);
    }

    public void drawString(String string, int x, int y, int colour, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.field_147003_i;
            factorY = this.field_147009_r;
        }
        this.field_146297_k.field_71466_p.func_78276_b(string, x + factorX, y + factorY, colour);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addPowerButton(int x, int y, int id, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.field_147003_i;
            factorY = this.field_147009_r;
        }
        this.field_146292_n.add(new GuiButtonPowerBar(id, x + factorX, y + factorY, this, layer));
    }

    public void addHologramButton(int x, int y, int id, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.field_147003_i;
            factorY = this.field_147009_r;
        }
        this.field_146292_n.add(new GuiButtonHologram(id, x + factorX, y + factorY, this, layer));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (slotConfigType == SlotConfigType.ITEMS && this.getMachine().hasSlotConfig() && GuiSlotConfiguration.mouseClicked(mouseX, mouseY, mouseButton, this)) {
            return;
        }
        if (slotConfigType == SlotConfigType.FLUIDS && this.getMachine().showTankConfig() && GuiFluidConfiguration.mouseClicked(mouseX, mouseY, mouseButton, this)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (slotConfigType == SlotConfigType.ITEMS && this.getMachine().hasSlotConfig()) {
            GuiSlotConfiguration.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this);
        }
        if (slotConfigType == SlotConfigType.FLUIDS && this.getMachine().showTankConfig()) {
            GuiFluidConfiguration.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this);
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        int offset = 0;
        if (!this.upgrades) {
            offset = 80;
        }
        if (this.func_146978_c(-26, 84 - offset, 30, 30, mouseX, mouseY) && this.getMachine().hasSlotConfig() && (slotConfigType = slotConfigType != SlotConfigType.ITEMS ? SlotConfigType.ITEMS : SlotConfigType.NONE) == SlotConfigType.ITEMS) {
            GuiSlotConfiguration.reset();
        }
        if (this.func_146978_c(-26, 84 - offset + 27, 30, 30, mouseX, mouseY) && this.getMachine().hasSlotConfig()) {
            slotConfigType = slotConfigType != SlotConfigType.FLUIDS ? SlotConfigType.FLUIDS : SlotConfigType.NONE;
        }
        if (slotConfigType == SlotConfigType.ITEMS && this.getMachine().hasSlotConfig() && GuiSlotConfiguration.mouseReleased(mouseX, mouseY, state, this)) {
            return;
        }
        if (slotConfigType == SlotConfigType.FLUIDS && this.getMachine().showTankConfig() && GuiFluidConfiguration.mouseReleased(mouseX, mouseY, state, this)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (slotConfigType == SlotConfigType.ITEMS) {
            if (GuiBase.func_146271_m() && keyCode == 46) {
                GuiSlotConfiguration.copyToClipboard();
                return;
            }
            if (GuiBase.func_146271_m() && keyCode == 47) {
                GuiSlotConfiguration.pasteFromClipboard();
                return;
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146281_b() {
        slotConfigType = SlotConfigType.NONE;
        super.func_146281_b();
    }

    public TileLegacyMachineBase getMachine() {
        return (TileLegacyMachineBase)this.tile;
    }

    public boolean isPointInRect(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public static interface FluidCellProvider {
        public ItemStack provide(Fluid var1);
    }

    public static enum SlotConfigType {
        NONE,
        ITEMS,
        FLUIDS;

    }

    public static enum Layer {
        BACKGROUND,
        FOREGROUND;

    }
}

