/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTurbineStats
extends GuiMekanismTile<TileEntityTurbineCasing> {
    public GuiTurbineStats(InventoryPlayer inventory, TileEntityTurbineCasing tile) {
        super((TileEntityContainerBlock)tile, (Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement((GuiElement)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tileEntity, GuiTurbineTab.TurbineTab.MAIN, 6, resource));
        this.addGuiElement((GuiElement)new GuiEnergyInfo(() -> {
            double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            return Arrays.asList(LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityTurbineCasing)this.tileEntity).getEnergy(), (double)((TileEntityTurbineCasing)this.tileEntity).getMaxEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientFlow * energyMultiplier)) + "/t");
        }, (IGuiWrapper)this, resource));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String stats = LangUtils.localize((String)"gui.turbineStats");
        String limiting = EnumColor.DARK_RED + " (" + LangUtils.localize((String)"gui.limiting") + ")";
        this.field_146289_q.func_78276_b(stats, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(stats) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.tankVolume") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume, 8, 26, 0x404040);
        boolean dispersersLimiting = (double)(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume * ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val() < (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val();
        boolean ventsLimiting = (double)(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume * ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers) * MekanismConfig.current().generators.turbineDisperserGasFlow.val() > (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val();
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.steamFlow"), 8, 40, 0x797979);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.dispersers") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers + (dispersersLimiting ? limiting : ""), 14, 49, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.vents") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents + (ventsLimiting ? limiting : ""), 14, 58, 0x404040);
        boolean bladesLimiting = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * 4 > ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades;
        boolean coilsLimiting = ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * 4 < ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades;
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.production"), 8, 72, 0x797979);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.blades") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades + (bladesLimiting ? limiting : ""), 14, 81, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.coils") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils + (coilsLimiting ? limiting : ""), 14, 90, 0x404040);
        double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).blades, ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
        double rate = (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).lowerVolume * ((double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
        rate = Math.min(rate, (double)((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.maxProduction") + ": " + MekanismUtils.getEnergyDisplay((double)(rate * energyMultiplier)), 8, 104, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.maxWaterOutput") + ": " + ((SynchronizedTurbineData)((TileEntityTurbineCasing)this.tileEntity).structure).condensers * MekanismConfig.current().generators.condenserRate.val() + " mB/t", 8, 113, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiNull.png");
    }
}

