/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import javax.annotation.Nonnull;
import net.machinemuse.numina.basemod.MuseLogger;
import net.machinemuse.numina.capabilities.energy.adapter.IMuseElectricItem;
import net.machinemuse.numina.client.render.modelspec.ModelRegistry;
import net.machinemuse.numina.client.render.modelspec.TexturePartSpec;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.module.IModuleManager;
import net.machinemuse.numina.string.MuseStringUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.utils.nbt.MPSNBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IModularItemBase
extends IModularItem,
IMuseElectricItem {
    default public double getMaxBaseHeat(@Nonnull ItemStack itemStack) {
        return MPSConfig.INSTANCE.getBaseMaxHeat(itemStack);
    }

    default public Colour getColorFromItemStack(@Nonnull ItemStack stack) {
        try {
            NBTTagCompound renderTag = MPSNBTUtils.getMuseRenderTag(stack);
            if (renderTag.func_74764_b("texSpec")) {
                TexturePartSpec partSpec = (TexturePartSpec)ModelRegistry.getInstance().getPart(renderTag.func_74775_l("texSpec"));
                NBTTagCompound specTag = renderTag.func_74775_l("texSpec");
                int index = partSpec.getColourIndex(specTag);
                int[] colours = renderTag.func_74759_k("colours");
                if (colours.length > index) {
                    return new Colour(colours[index]);
                }
            }
        }
        catch (Exception e) {
            MuseLogger.logException((String)"something failed here: ", (Throwable)e);
        }
        return Colour.WHITE;
    }

    default public String formatInfo(String string, double value) {
        return string + '\t' + MuseStringUtils.formatNumberShort((double)value);
    }

    default public IModuleManager getModuleManager() {
        return ModuleManager.INSTANCE;
    }

    default public double getArmorDouble(EntityPlayer player, ItemStack stack) {
        return 0.0;
    }
}

