/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.tileentity.EnumMachineMode;
import omtteam.omlib.tileentity.TileEntityContainerElectric;

public abstract class TileEntityMachine
extends TileEntityContainerElectric {
    protected boolean active = false;
    protected boolean redstone = false;
    protected EnumMachineMode mode;

    public TileEntityMachine() {
        this.storage = new OMEnergyStorage(10, 10);
        this.active = true;
        this.mode = EnumMachineMode.INVERTED;
    }

    public void toggleMode() {
        this.mode = this.mode.ordinal() < EnumMachineMode.values().length - 1 ? EnumMachineMode.values()[this.mode.ordinal() + 1] : EnumMachineMode.values()[0];
        this.refreshActive(this.mode);
    }

    protected void refreshActive(EnumMachineMode mode) {
        switch (mode) {
            case INVERTED: {
                this.active = !this.redstone;
                break;
            }
            case NONINVERTED: {
                this.active = this.redstone;
                break;
            }
            case ALWAYS_ON: {
                this.active = true;
                break;
            }
            case ALWAYS_OFF: {
                this.active = false;
            }
        }
    }

    public EnumMachineMode getMode() {
        return this.mode;
    }

    public void setMode(EnumMachineMode mode) {
        this.mode = mode;
        this.refreshActive(this.mode);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("active", this.active);
        nbtTagCompound.func_74757_a("redstone", this.redstone);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.active = !nbtTagCompound.func_74764_b("active") || nbtTagCompound.func_74767_n("active");
        this.redstone = nbtTagCompound.func_74767_n("redstone");
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean getRedstone() {
        return this.redstone;
    }

    public void setRedstone(boolean redstone) {
        this.redstone = redstone;
        this.refreshActive(this.mode);
    }
}

