/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.multiblock;

import icbm.classic.content.multiblock.TileMulti;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMultiblock
extends BlockContainer {
    public BlockMultiblock() {
        super(Material.field_151576_e);
        this.setRegistryName("icbmclassic", "multiblock");
        this.func_149663_c("icbmclassic:multiblock");
        this.func_149711_c(2.0f);
        this.field_149789_z = true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileMulti) {
            if (!((TileMulti)tile).hasHost()) {
                worldIn.func_175698_g(pos);
            } else if (((TileMulti)tile).isHostLoaded() && ((TileMulti)tile).getHost() == null) {
                worldIn.func_175698_g(pos);
            }
        }
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileMulti multiblock = this.getTile(world, pos);
        if (multiblock != null && multiblock.getHost() instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)multiblock.getHost();
            IBlockState blockState = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
            Block block = blockState.func_177230_c();
            blockState = block.func_176221_a(blockState, (IBlockAccess)world, pos);
            ItemStack stack = block.getPickBlock(blockState, target, world, tileEntity.func_174877_v(), player);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null && tile.getHost() != null) {
            tile.getHost().onMultiTileAdded(tile);
        }
        super.func_176213_c(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null && tile.getHost() != null) {
            tile.getHost().onMultiTileBroken(tile, null, true);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null && tile.getHost() != null) {
            tile.getHost().onMultiTileBroken(tile, player, willHarvest);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion ex) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null && tile.getHost() != null) {
            tile.getHost().onMultiTileBroken(tile, ex, true);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null) {
            if (!world.field_72995_K && (!tile.hasHost() || tile.isHostLoaded() && tile.getHost() == null)) {
                world.func_175698_g(pos);
                return true;
            }
            return tile.getHost() != null && tile.getHost().onMultiTileActivated(tile, player, hand, side, hitX, hitY, hitZ);
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileMulti tile = this.getTile(world, pos);
        if (tile != null) {
            if (!world.field_72995_K && (!tile.hasHost() || tile.isHostLoaded() && tile.getHost() == null)) {
                world.func_175698_g(pos);
                return;
            }
            if (tile.getHost() != null) {
                tile.getHost().onMultiTileClicked(tile, player);
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileMulti();
    }

    protected TileMulti getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMulti) {
            return (TileMulti)tile;
        }
        return null;
    }
}

