/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.advert;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.advert.ServerAdvert;
import org.apache.commons.lang3.StringUtils;

public abstract class Advert
implements Comparable<Advert> {
    protected static String advertDir = "adverts/";
    protected int id;
    protected String name;
    protected long size;
    protected int width;
    protected int height;
    protected String url;
    private String error;
    protected File file;
    protected String hash;

    public Advert(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public long getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public void setInfos(String name, String url) {
        this.name = name;
        this.url = url;
        this.error = null;
    }

    public void setHash(String hash) {
        this.hash = hash;
        this.setFile();
    }

    public void setData(long size, int width, int height) {
        this.size = size;
        this.width = width;
        this.height = height;
    }

    protected String calculateHash(byte[] img) {
        return Hashing.md5().hashBytes(img).toString();
    }

    public File getFile() {
        return this.file;
    }

    protected void setFile() {
        if (!StringUtils.isEmpty((CharSequence)this.name) && !StringUtils.isEmpty((CharSequence)this.hash)) {
            this.file = new File(advertDir, this.hash);
            this.loadFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeFile(byte[] img) {
        this.setHash(this.calculateHash(img));
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            fos.write(img);
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            MalisisAdvert.log.error((Object)e);
            return false;
        }
    }

    protected void loadFile() {
        if (this.file == null || !this.file.exists()) {
            return;
        }
        this.size = this.file.length();
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(Files.toByteArray((File)this.file)));
            if (img != null) {
                this.width = img.getWidth();
                this.height = img.getHeight();
            }
        }
        catch (IOException e) {
            MalisisAdvert.log.error("Could not get image infos for {}", (Object)this, (Object)e);
        }
    }

    protected abstract void downloadFile();

    public boolean isDownloaded() {
        return this.file.exists();
    }

    public void save() {
    }

    public void delete() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    @Override
    public int compareTo(Advert o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object obj) {
        return obj instanceof Advert && ((Advert)obj).id == this.id;
    }

    public String toString() {
        String str = "";
        if (this instanceof ClientAdvert) {
            str = str + "[C]";
        } else if (this instanceof ServerAdvert) {
            str = str + "[S]";
        }
        str = str + " (" + this.id + ") " + this.name + " - " + this.url;
        return str;
    }
}

