/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.items.SpawnActionItem;
import com.pixelmonmod.pixelmon.util.NBTTools;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class SpawnInfoItem
extends SpawnInfo {
    public static final String TYPE_ID_ITEM = "item";
    public String itemID = "minecraft:string";
    public int minQuantity = 1;
    public int maxQuantity = 1;
    public int meta = -1;
    public Map<String, Object> nbt = null;
    public transient ItemStack itemStack = null;

    public SpawnInfoItem() {
        super(TYPE_ID_ITEM);
    }

    @Override
    public void onImport() {
        super.onImport();
        Item item = null;
        if (this.itemID.contains(":")) {
            ResourceLocation resourceLocation = new ResourceLocation(this.itemID.split(":")[0], this.itemID.split(":")[1]);
            item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation);
            if (item == null) {
                Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                return;
            }
        } else {
            ArrayList matchingItems = new ArrayList();
            Item.field_150901_e.forEach(testItem -> {
                if (testItem.getRegistryName().func_110623_a().equalsIgnoreCase(this.itemID)) {
                    matchingItems.add(testItem);
                }
            });
            if (matchingItems.isEmpty()) {
                Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                return;
            }
            if (matchingItems.size() > 1) {
                Pixelmon.LOGGER.error("Duplicate items found for item ID in SpawnInfo: " + this.itemID + ". Prefix this id with the resource domain, such as: 'minecraft:'");
                return;
            }
            item = (Item)matchingItems.get(0);
        }
        this.itemStack = this.meta == -1 ? new ItemStack(item) : new ItemStack(item, this.meta);
        NBTTagCompound deserializedNBT = null;
        if (this.nbt != null) {
            deserializedNBT = NBTTools.nbtFromMap(this.nbt);
        }
        if (deserializedNBT != null) {
            this.itemStack.func_77982_d(deserializedNBT);
            if (deserializedNBT.func_74764_b("Damage")) {
                this.itemStack.func_77964_b(deserializedNBT.func_74762_e("Damage"));
            }
        }
    }

    public SpawnAction<? extends EntityItem> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        return new SpawnActionItem(this, spawnLocation);
    }

    @Override
    public String toString() {
        return this.itemStack.func_82833_r();
    }
}

